/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.wso2.maven.Task;
import org.wso2.maven.Utils;

@Mojo(name="merge")
public class Merge
extends AbstractMojo {
    @Parameter
    private List<Task> tasks;

    public void execute() throws MojoExecutionException, MojoFailureException {
        for (Task taskModel : this.tasks) {
            String config = taskModel.getConfig();
            String input = taskModel.getInput();
            String output = taskModel.getOutput();
            Map inputMap = Utils.getReadMap(input);
            Map outputMap = Utils.getReadMap(config);
            Utils.mergeMaps(inputMap, outputMap);
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(output));
                Throwable throwable = null;
                try {
                    bufferedWriter.write(Utils.convertIntoJson(outputMap));
                    bufferedWriter.flush();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (bufferedWriter == null) continue;
                    if (throwable != null) {
                        try {
                            bufferedWriter.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    bufferedWriter.close();
                }
            }
            catch (IOException e) {
                throw new MojoFailureException((Object)e, "Error while Writing Merged Json", "Error while writing Json");
            }
        }
    }
}

