/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;

public class Utils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map getReadMap(String path) throws MojoExecutionException {
        if (!Paths.get(path, new String[0]).toFile().exists()) return new HashMap();
        Gson gson = new Gson();
        try (FileInputStream fileInputStream = new FileInputStream(path);){
            InputStreamReader input = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
            Map map = (Map)gson.fromJson((Reader)input, Map.class);
            return map;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while reading json file", (Exception)e);
        }
    }

    public static String convertIntoJson(Map input) {
        Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();
        return gson.toJson((Object)input);
    }

    public static Map<String, Object> mergeMaps(Map<String, Object> baseMap, Map<String, Object> input, boolean isChildMergeEnabled) {
        for (Map.Entry<String, Object> entry : input.entrySet()) {
            String key = entry.getKey();
            Map<String, Object> value = entry.getValue();
            Object returnedValue = baseMap.get(key);
            if (returnedValue == null) {
                baseMap.put(key, value);
                continue;
            }
            if (!(returnedValue instanceof Map) || !isChildMergeEnabled) continue;
            value = Utils.mergeMaps((Map)returnedValue, value, true);
            baseMap.put(key, value);
        }
        return baseMap;
    }
}

