/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.pckg.prepare;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.FactoryConfigurationError;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.wso2.developerstudio.eclipse.utils.file.FileUtils;
import org.wso2.maven.core.utils.MavenUtils;
import org.wso2.maven.pckg.prepare.util.PackagePrepareUtils;

public class PackagePrepareSystemScopeMojo
extends AbstractMojo {
    private static final String USER_CONSENT_PROMPTER = "Continue? [Y/n]";
    private static final String USER_CONSENT_YES = "y";
    private static final String USER_CONSENT_NO = "n";
    private static final String USER_CONSENT_DEFAULT = "";
    private final Log log = this.getLog();
    private MavenProject project;
    private boolean dryRun;
    private boolean updateDependencies;
    private Prompter prompter;
    private List<MavenProject> cappMavenProjects;
    private Map<String, String> dependencySystemPathMap;
    private boolean isDebugEnabled;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.isDebugEnabled = this.log.isDebugEnabled();
        this.log.info((CharSequence)"MavenPackagePrepare plugin execution started");
        if (this.dryRun) {
            this.log.warn((CharSequence)" **** wso2-maven-package-prepare-plugin does not support dryRun mode **** ");
            throw new MojoExecutionException(" **** wso2-maven-package-prepare-plugin does not support dryRun mode **** ");
        }
        List modules = this.project.getModules();
        if (null != modules && !modules.isEmpty()) {
            List<MavenProject> mavenProjects = this.getMavenProjects(modules);
            this.aggregateDependencies(mavenProjects);
            this.filterAllCappProjects(mavenProjects);
            if (!this.updateCappDependencies()) {
                this.log.error((CharSequence)"Plugin execution terminated");
                throw new MojoFailureException("Plugin execution terminated");
            }
        } else {
            this.log.error((CharSequence)("\"" + this.project.getBasedir() + "\" does not contain a Maven Multi-Module project. Please execute this plugin on the root of a Maven Multi-Module project"));
            throw new MojoExecutionException("\"" + this.project.getBasedir() + "\" does not contain a Maven Multi-Module project. Please execute this plugin on the root of a Maven Multi-Module project");
        }
    }

    private List<MavenProject> getMavenProjects(List<String> modules) {
        ArrayList<MavenProject> projectList = new ArrayList<MavenProject>();
        for (String module : modules) {
            MavenProject parsedMavenProject;
            if (this.isDebugEnabled) {
                this.log.debug((CharSequence)("Reading module: " + module));
            }
            StringBuilder modulePomFilePath = new StringBuilder();
            modulePomFilePath.append(module);
            modulePomFilePath.append(File.separator);
            modulePomFilePath.append("pom.xml");
            File modulePomFile = new File(modulePomFilePath.toString());
            if (!modulePomFile.exists()) {
                this.log.error((CharSequence)("Cannot find a pom file in location: " + modulePomFilePath));
                continue;
            }
            try {
                parsedMavenProject = MavenUtils.getMavenProject((File)modulePomFile);
            }
            catch (MojoExecutionException e) {
                this.log.error((CharSequence)("Failed to parse pom file of the module: " + module), (Throwable)e);
                continue;
            }
            parsedMavenProject.setFile(modulePomFile);
            projectList.add(parsedMavenProject);
        }
        return projectList;
    }

    private void aggregateDependencies(List<MavenProject> mavenProjects) {
        this.dependencySystemPathMap = new HashMap<String, String>();
        for (MavenProject mavenProject : mavenProjects) {
            String packaging = mavenProject.getPackaging();
            if (packaging != null && "carbon/application".equals(packaging)) continue;
            try {
                this.dependencySystemPathMap.putAll(PackagePrepareUtils.getArtifactsSystemPathMap(mavenProject));
            }
            catch (Exception | FactoryConfigurationError e) {
                this.log.warn((CharSequence)("Failed to retrieve dependencies from project: " + mavenProject.getGroupId() + ":" + mavenProject.getArtifactId() + ":" + mavenProject.getVersion()), e);
            }
        }
        if (this.isDebugEnabled) {
            Iterator<Map.Entry<String, String>> dependencyIterator = this.dependencySystemPathMap.entrySet().iterator();
            while (dependencyIterator.hasNext()) {
                this.log.debug((CharSequence)("Identified system path of: " + dependencyIterator.next().getKey()));
            }
        }
    }

    private void filterAllCappProjects(List<MavenProject> mavenProjects) {
        this.cappMavenProjects = new ArrayList<MavenProject>();
        for (MavenProject mavenProject : mavenProjects) {
            String packaging = mavenProject.getPackaging();
            if (packaging == null || !packaging.equals("carbon/application")) continue;
            if (this.isDebugEnabled) {
                this.log.debug((CharSequence)("Identified the composite application project: " + mavenProject.getGroupId() + ":" + mavenProject.getArtifactId() + ":" + mavenProject.getVersion()));
            }
            this.cappMavenProjects.add(mavenProject);
        }
    }

    private boolean updateCappDependencies() {
        for (MavenProject cappMavenProject : this.cappMavenProjects) {
            this.log.info((CharSequence)("About to update: " + cappMavenProject.getFile().getAbsolutePath()));
            this.log.warn((CharSequence)"All dependencies will be converted to system scope");
            if (this.updateDependencies) {
                if (this.updatePomFile(cappMavenProject)) continue;
                return false;
            }
            String userInput = USER_CONSENT_DEFAULT;
            do {
                try {
                    userInput = this.prompter.prompt(USER_CONSENT_PROMPTER);
                }
                catch (PrompterException e) {
                    this.log.error((CharSequence)"Failed to get user input while updating dependencies", (Throwable)e);
                    return false;
                }
            } while (!USER_CONSENT_DEFAULT.equalsIgnoreCase(userInput) && !USER_CONSENT_YES.equalsIgnoreCase(userInput) && !USER_CONSENT_NO.equalsIgnoreCase(userInput));
            if (USER_CONSENT_NO.equalsIgnoreCase(userInput)) {
                this.log.info((CharSequence)("Skipped updating file: " + cappMavenProject.getFile().getAbsolutePath()));
                continue;
            }
            if (this.updatePomFile(cappMavenProject)) continue;
            return false;
        }
        return true;
    }

    private boolean updatePomFile(MavenProject cappMavenProject) {
        List dependencies = cappMavenProject.getDependencies();
        for (Dependency dependency : dependencies) {
            dependency.setScope("system");
            String absoluteSystemPath = this.resolveDependencySystemPath(dependency);
            if (StringUtils.isNotEmpty((String)absoluteSystemPath)) {
                StringBuilder systemPathBuilder = new StringBuilder();
                systemPathBuilder.append("${basedir}");
                systemPathBuilder.append(File.separator);
                systemPathBuilder.append(FileUtils.getRelativePath((File)new File(cappMavenProject.getBasedir().toString()), (File)new File(absoluteSystemPath)));
                dependency.setSystemPath(systemPathBuilder.toString());
                continue;
            }
            return false;
        }
        try {
            MavenUtils.saveMavenProject((MavenProject)cappMavenProject, (File)cappMavenProject.getFile());
        }
        catch (Exception e) {
            this.log.error((CharSequence)"Failed to save the pom file", (Throwable)e);
            return false;
        }
        this.log.info((CharSequence)"All dependencies were converted to system scope");
        return true;
    }

    private String resolveDependencySystemPath(Dependency dependency) {
        StringBuilder dependencyStringBuilder = new StringBuilder();
        dependencyStringBuilder.append(dependency.getGroupId());
        dependencyStringBuilder.append(":");
        dependencyStringBuilder.append(dependency.getArtifactId());
        dependencyStringBuilder.append(":");
        dependencyStringBuilder.append(dependency.getVersion());
        String dependencyString = dependencyStringBuilder.toString();
        String systemPath = this.dependencySystemPathMap.get(dependencyString);
        if (systemPath != null) {
            return systemPath;
        }
        this.log.error((CharSequence)("Could not resolve dependency: " + dependencyString + " from any sub module"));
        return USER_CONSENT_DEFAULT;
    }
}

