/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.pckg.prepare.util;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.FactoryConfigurationError;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;
import org.wso2.maven.core.utils.MavenConstants;
import org.wso2.maven.esb.ESBArtifact;
import org.wso2.maven.esb.ESBProjectArtifact;

public class PackagePrepareUtils {
    public static Map<String, String> getArtifactsSystemPathMap(MavenProject project) throws FactoryConfigurationError, Exception {
        HashMap<String, String> dependencyData = new HashMap<String, String>();
        StringBuilder artifactXMLPathBuilder = new StringBuilder();
        artifactXMLPathBuilder.append(project.getBasedir().toString());
        artifactXMLPathBuilder.append(File.separator);
        artifactXMLPathBuilder.append("artifact.xml");
        File artifactXMLFile = new File(artifactXMLPathBuilder.toString());
        if (artifactXMLFile.exists()) {
            ESBProjectArtifact artifactXMLDoc = new ESBProjectArtifact();
            artifactXMLDoc.fromFile(artifactXMLFile);
            List artifacts = artifactXMLDoc.getAllESBArtifacts();
            for (ESBArtifact artifact : artifacts) {
                String dependencyString = PackagePrepareUtils.getDependencyString(project, artifact);
                String artifactPostFix = PackagePrepareUtils.getArtifactPostFix(artifact);
                StringBuilder systemPathBuilder = new StringBuilder();
                systemPathBuilder.append(project.getBasedir().toString());
                systemPathBuilder.append(File.separator);
                systemPathBuilder.append(MavenConstants.ESB_PROJECT_TARGET_CAPP);
                String outputDirPath = systemPathBuilder.toString();
                systemPathBuilder = new StringBuilder();
                systemPathBuilder.append(outputDirPath);
                systemPathBuilder.append(File.separator);
                systemPathBuilder.append(artifactPostFix);
                systemPathBuilder.append(File.separator);
                systemPathBuilder.append(artifact.getName());
                systemPathBuilder.append(File.separator);
                systemPathBuilder.append("pom.xml");
                String systemPath = systemPathBuilder.toString();
                dependencyData.put(dependencyString, systemPath);
            }
        }
        return dependencyData;
    }

    private static String getArtifactPostFix(ESBArtifact artifact) {
        String artifactType = "synapse/sequenceTemplate".equals(artifact.getType()) || "synapse/endpointTemplate".equals(artifact.getType()) ? "synapse/template" : artifact.getType();
        if ("synapse/configuration".equalsIgnoreCase(artifactType)) {
            return artifactType.substring(0, artifactType.indexOf("/"));
        }
        return artifactType.substring(artifactType.indexOf("/") + 1);
    }

    private static String getDependencyString(MavenProject project, ESBArtifact artifact) {
        String groupId = StringUtils.isNotEmpty((String)artifact.getGroupId()) ? artifact.getGroupId() : project.getGroupId();
        String artifactId = artifact.getName();
        String version = artifact.getVersion();
        StringBuilder dependencyStringBuilder = new StringBuilder();
        dependencyStringBuilder.append(groupId);
        dependencyStringBuilder.append(":");
        dependencyStringBuilder.append(artifactId);
        dependencyStringBuilder.append(":");
        dependencyStringBuilder.append(version);
        return dependencyStringBuilder.toString();
    }
}

