/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven;

import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.wso2.maven.ConnectorMojo;

public class ComponentXmlGenerator {
    public static void generateComponentXmls(ConnectorMojo connectorMojo) {
        String componentsPath = "src" + File.separator + "main" + File.separator + "resources";
        File componentsFolder = new File(componentsPath);
        for (File folder : componentsFolder.listFiles()) {
            if (!folder.isDirectory() || new File(folder.getPath() + File.separator + "component.xml").exists()) continue;
            boolean containsXml = false;
            for (File file : folder.listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(".xml")) continue;
                containsXml = true;
                break;
            }
            if (!containsXml) continue;
            String componentName = folder.getName();
            ComponentXmlGenerator.generateComponentXml(componentName, folder.getPath(), connectorMojo);
        }
    }

    private static void generateComponentXml(String componentName, String folderPath, ConnectorMojo connectorMojo) {
        String targetComponentsPath = "target" + File.separator + "classes" + File.separator + componentName;
        String outputFileName = targetComponentsPath + File.separator + "component.xml";
        try (FileWriter writer = new FileWriter(outputFileName);){
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            writer.write("<!-- Auto-generated file. Do not modify manually. -->\n");
            writer.write("<component name=\"" + componentName + "\" type=\"synapse/template\">\n");
            writer.write("    <subComponents>\n");
            File folder = new File(folderPath);
            File[] files = folder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".xml");
                }
            });
            if (files != null) {
                for (File file : files) {
                    String fileName = file.getName();
                    String component = fileName.substring(0, fileName.lastIndexOf(46));
                    String description = ComponentXmlGenerator.extractDescription(file);
                    writer.write("        <component name=\"" + component + "\">\n");
                    writer.write("            <file>" + fileName + "</file>\n");
                    writer.write("            <description>" + description + "</description>\n");
                    writer.write("        </component>\n");
                }
            }
            writer.write("    </subComponents>\n");
            writer.write("</component>\n");
        }
        catch (Exception e) {
            connectorMojo.getLog().error((CharSequence)("Error generating component.xml for " + componentName + ": " + e.getMessage()));
        }
    }

    private static String extractDescription(File file) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(file);
        document.getDocumentElement().normalize();
        NodeList nodeList = document.getElementsByTagName("description");
        if (nodeList.getLength() > 0) {
            return nodeList.item(0).getTextContent().trim();
        }
        return "";
    }
}

