/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.maven.ComponentXmlGenerator;
import org.wso2.maven.ConnectorXmlGenerator;
import org.wso2.maven.DescriptorGenerator;

public class ConnectorMojo
extends AbstractMojo {
    private String connectorName;
    private String packageName;

    public void execute() throws MojoExecutionException {
        this.populateConnectorData();
        ConnectorXmlGenerator.generateConnectorXml(this.connectorName, this.packageName, this);
        ComponentXmlGenerator.generateComponentXmls(this);
        DescriptorGenerator.generateDescriptor(this);
    }

    private void populateConnectorData() throws MojoExecutionException {
        String pomFilePath = "pom.xml";
        try {
            File pomFile = new File(pomFilePath);
            if (!pomFile.exists()) {
                throw new MojoExecutionException("POM file not found at: " + pomFilePath);
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(pomFile);
            document.getDocumentElement().normalize();
            this.connectorName = ConnectorMojo.getProperty(document, "connector.name");
            if (this.connectorName == null || this.connectorName.isEmpty()) {
                throw new MojoExecutionException("The property 'connector.name' is not defined in the POM file.");
            }
            String groupId = ConnectorMojo.getTagValue(document, "groupId");
            if (groupId == null) {
                throw new MojoExecutionException("The 'groupId' is not defined in the POM file.");
            }
            this.packageName = groupId;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Populating connector data failed", e);
        }
    }

    private static String getProperty(Document document, String propertyName) {
        Node propertiesNode;
        NodeList propertiesNodeList = document.getElementsByTagName("properties");
        if (propertiesNodeList.getLength() > 0 && (propertiesNode = propertiesNodeList.item(0)).getNodeType() == 1) {
            Element propertiesElement = (Element)propertiesNode;
            NodeList childNodes = propertiesElement.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node child = childNodes.item(i);
                if (child.getNodeType() != 1 || !child.getNodeName().equals(propertyName)) continue;
                return child.getTextContent().trim();
            }
        }
        return null;
    }

    private static String getTagValue(Document document, String tagName) {
        NodeList nodeList = document.getElementsByTagName(tagName);
        if (nodeList.getLength() > 0) {
            Node node = nodeList.item(0);
            return node.getTextContent().trim();
        }
        return null;
    }
}

