/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.wso2.maven.ConnectorMojo;

public class ConnectorXmlGenerator {
    public static void generateConnectorXml(String connectorName, String connectorPackage, ConnectorMojo connectorMojo) {
        String outputFileName = "target" + File.separator + "classes" + File.separator + "connector.xml";
        File outputFile = new File(outputFileName);
        if (outputFile.exists()) {
            connectorMojo.getLog().info((CharSequence)"connector.xml file already exists. Skipping generation.");
            return;
        }
        try (FileWriter writer = new FileWriter(outputFileName);){
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            writer.write("<!-- This file is autogenerated. Do not modify manually. -->\n\n");
            writer.write("<connector>\n");
            writer.write("    <component name=\"" + connectorName + "\" package=\"" + connectorPackage + "\">\n");
            File rootFolder = new File("src/main/resources");
            File[] files = rootFolder.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.isDirectory() || file.listFiles() == null) continue;
                    boolean containsXml = false;
                    for (File innerFile : file.listFiles()) {
                        if (!innerFile.isFile() || !innerFile.getName().endsWith(".xml")) continue;
                        containsXml = true;
                        break;
                    }
                    if (!containsXml) continue;
                    writer.write("        <dependency component=\"" + file.getName() + "\"/>\n");
                }
            }
            writer.write("        <description>wso2 " + connectorName + " connector library</description>\n");
            writer.write("    </component>\n");
            String iconPath = ConnectorXmlGenerator.deriveIconPath();
            if (!iconPath.isEmpty()) {
                writer.write("    <icon>" + iconPath + "</icon>\n");
            }
            writer.write("</connector>\n");
            connectorMojo.getLog().info((CharSequence)"connector.xml file generated successfully.");
        }
        catch (IOException e) {
            connectorMojo.getLog().error((CharSequence)"Error occurred while generating connector.xml file.", (Throwable)e);
        }
    }

    private static String deriveIconPath() {
        String iconFolder = "src" + File.separator + "main" + File.separator + "resources" + File.separator + "icon";
        if (new File(iconFolder + File.separator + "icon-small.gif").exists()) {
            return "icon" + File.separator + "icon-small.gif";
        }
        if (new File(iconFolder + File.separator + "icon-small.png").exists()) {
            return "icon" + File.separator + "icon-small.png";
        }
        return "";
    }
}

