/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven;

import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.maven.ConnectorMojo;

public class DescriptorGenerator {
    public static void generateDescriptor(ConnectorMojo connectorMojo) {
        String pomFilePath = "pom.xml";
        String outputFilePath = "target" + File.separator + "classes" + File.separator + "dependency.xml";
        try {
            Map<String, String> properties = DescriptorGenerator.parsePomProperties(pomFilePath);
            DescriptorGenerator.generateDependencyXml(pomFilePath, outputFilePath, properties);
            connectorMojo.getLog().info((CharSequence)("Dependency file generated at: " + outputFilePath));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Map<String, String> parsePomProperties(String pomFilePath) throws Exception {
        Node propertiesNode;
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        File pomFile = new File(pomFilePath);
        if (!pomFile.exists()) {
            throw new Exception("POM file not found at: " + pomFilePath);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(pomFile);
        document.getDocumentElement().normalize();
        NodeList propertiesNodeList = document.getElementsByTagName("properties");
        if (propertiesNodeList.getLength() > 0 && (propertiesNode = propertiesNodeList.item(0)).getNodeType() == 1) {
            Element propertiesElement = (Element)propertiesNode;
            NodeList childNodes = propertiesElement.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node child = childNodes.item(i);
                if (child.getNodeType() != 1) continue;
                String key = child.getNodeName();
                String value = child.getTextContent().trim();
                propertiesMap.put(key, value);
            }
        }
        return propertiesMap;
    }

    private static void generateDependencyXml(String pomFilePath, String outputFilePath, Map<String, String> properties) throws Exception {
        File pomFile = new File(pomFilePath);
        if (!pomFile.exists()) {
            throw new Exception("POM file not found at: " + pomFilePath);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(pomFile);
        document.getDocumentElement().normalize();
        NodeList dependencyNodes = document.getElementsByTagName("dependency");
        StringBuilder xmlBuilder = new StringBuilder();
        xmlBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        xmlBuilder.append("<descriptor>\n");
        xmlBuilder.append("    <dependencies>\n");
        for (int i = 0; i < dependencyNodes.getLength(); ++i) {
            String propertyKey;
            Node dependencyNode = dependencyNodes.item(i);
            if (dependencyNode.getNodeType() != 1) continue;
            Element dependencyElement = (Element)dependencyNode;
            String groupId = DescriptorGenerator.getTextContent(dependencyElement, "groupId");
            String artifactId = DescriptorGenerator.getTextContent(dependencyElement, "artifactId");
            String version = DescriptorGenerator.getTextContent(dependencyElement, "version");
            String scope = DescriptorGenerator.getTextContent(dependencyElement, "scope");
            if (!"runtime".equals(scope)) continue;
            if (version.startsWith("${") && version.endsWith("}") && (version = properties.get(propertyKey = version.substring(2, version.length() - 1))) == null) {
                throw new Exception("Version placeholder '" + propertyKey + "' is not defined in the POM properties.");
            }
            xmlBuilder.append("        <dependency>\n");
            xmlBuilder.append("            <groupId>").append(groupId).append("</groupId>\n");
            xmlBuilder.append("            <artifactId>").append(artifactId).append("</artifactId>\n");
            xmlBuilder.append("            <version>").append(version).append("</version>\n");
            xmlBuilder.append("        </dependency>\n");
        }
        xmlBuilder.append("    </dependencies>\n");
        xmlBuilder.append("    <repositories>\n");
        NodeList repositoryNodes = document.getElementsByTagName("repository");
        for (int i = 0; i < repositoryNodes.getLength(); ++i) {
            Node repositoryNode = repositoryNodes.item(i);
            if (repositoryNode.getNodeType() != 1) continue;
            Element repositoryElement = (Element)repositoryNode;
            String id = DescriptorGenerator.getTextContent(repositoryElement, "id");
            String url = DescriptorGenerator.getTextContent(repositoryElement, "url");
            xmlBuilder.append("        <repository>\n");
            xmlBuilder.append("            <id>").append(id).append("</id>\n");
            xmlBuilder.append("            <url>").append(url).append("</url>\n");
            xmlBuilder.append("        </repository>\n");
        }
        xmlBuilder.append("    </repositories>\n");
        xmlBuilder.append("</descriptor>\n");
        try (FileWriter writer = new FileWriter(outputFilePath);){
            writer.write(xmlBuilder.toString());
        }
    }

    private static String getTextContent(Element parent, String tagName) {
        NodeList nodeList = parent.getElementsByTagName(tagName);
        if (nodeList.getLength() > 0) {
            return nodeList.item(0).getTextContent().trim();
        }
        return "";
    }
}

