/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public abstract class AbstractMavenReleaseMojo
extends AbstractMojo {
    protected static final String ARTIFACT_XML = "artifact.xml";
    protected static final String ARTIFACT_XML_REGEX = "**/artifact.xml";
    protected static final String EMPTY_STRING = "";
    protected static final String POM_XML = "pom.xml";
    protected static final String PROJECT_PREFIX = "project.";
    protected static final String ARTIFACT_XML_TMP_FILE = "artifact.xml.tmp";
    protected static final String RELEASE_PROPERTIES = "release.properties";
    protected static final String WSO2_RELEASE_PLUGIN_PREFIX = "[wso2-release-plugin]";
    protected static final String ARTIFACT = "artifact";
    protected static final String VERSION = "version";
    protected static final String MAVEN_PLUGINS_GROUP = "org.apache.maven.plugins";
    protected static final String MAVEN_SCM_PLUGIN = "maven-scm-plugin";
    protected static final String SCM_PLUGIN_VERSION = "1.9.4";
    protected static final String GOAL_CHECK_IN = "checkin";
    protected static final String PARAMETER_BASEDIR = "basedir";
    protected static final String PARAMETER_MESSAGE = "message";
    protected static final String PARAM_INCLUDES = "includes";
    protected static final String PARAM_USERNAME = "username";
    protected static final String PARAM_PASSWORD = "password";
    protected static final String PROP_SCM_TAG = "scm.tag";
    protected static final String PROP_SCM_USERNAME = "scm.username";
    protected static final String PROP_SCM_PASSWORD = "scm.password";
    protected MavenProject mavenProject;
    protected MavenSession mavenSession;
    protected BuildPluginManager pluginManager;
    protected Properties releaseProperties;
    protected final Log log = this.getLog();

    protected abstract String getGoal();

    protected abstract String getDryRunFilePrefix();

    protected abstract String getCommitMessage(Properties var1);

    protected abstract String getNewVersion(File var1) throws IOException, XmlPullParserException;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File parentProjectBaseDir = this.mavenProject.getBasedir();
        File releasePropertiesFile = new File(parentProjectBaseDir, RELEASE_PROPERTIES);
        this.releaseProperties = new Properties();
        if (releasePropertiesFile.exists()) {
            try {
                FileInputStream inputStream = new FileInputStream(releasePropertiesFile);
                this.releaseProperties.load(inputStream);
            }
            catch (IOException e) {
                String errorMessage = "Error while reading release.properties";
                throw new MojoExecutionException(errorMessage, (Exception)e);
            }
            Collection artifactXMLFiles = FileUtils.listFiles((File)parentProjectBaseDir, (IOFileFilter)new ArtifactXMLFilter(), (IOFileFilter)TrueFileFilter.INSTANCE);
            for (File artifactXML : artifactXMLFiles) {
                File projectPath = new File(artifactXML.getPath().replaceAll("artifact.xml$", EMPTY_STRING));
                File pomFile = new File(projectPath, POM_XML);
                if (!pomFile.exists()) {
                    this.log.warn((CharSequence)("Skipping project since " + artifactXML.getPath() + " does not belong to a maven project."));
                    continue;
                }
                try {
                    String newVersion = this.getNewVersion(artifactXML);
                    if (StringUtils.isNotEmpty((String)newVersion)) {
                        this.updateArtifactVersions(artifactXML, newVersion);
                        continue;
                    }
                    String errorMessage = "Cannot update artifact.xml as new version is empty/null. Project: " + pomFile.getPath() + " Goal: " + this.getGoal();
                    throw new MojoFailureException(errorMessage);
                }
                catch (IOException | XmlPullParserException e) {
                    String errorMessage = "Error occurred while getting the new version for artifacts. Project: " + pomFile.getPath() + " Goal: " + this.getGoal();
                    throw new MojoFailureException(errorMessage, e);
                }
                catch (Exception e) {
                    String errorMessage = "Error occurred while updating artifact versions. Project: " + pomFile.getPath() + " Goal: " + this.getGoal();
                    throw new MojoFailureException(errorMessage, (Throwable)e);
                }
            }
            if (this.isInDryRunMode()) {
                this.log.info((CharSequence)"Skipped committing changes in dryRun mode.");
            } else {
                try {
                    MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)MAVEN_PLUGINS_GROUP), (String)MojoExecutor.artifactId((String)MAVEN_SCM_PLUGIN), (String)MojoExecutor.version((String)SCM_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)GOAL_CHECK_IN), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])this.getScmPluginProperties(parentProjectBaseDir)), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
                }
                catch (MojoExecutionException e) {
                    throw new MojoExecutionException("Error occurred while invoking maven scm plug-in.", (Exception)((Object)e));
                }
            }
        } else {
            this.log.debug((CharSequence)"Skipping project since the release.properties file was not found in project root.");
        }
    }

    protected void updateArtifactVersions(File artifactXml, String newVersion) throws Exception {
        FileInputStream inputStream = new FileInputStream(artifactXml);
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
        StAXOMBuilder builder = new StAXOMBuilder(xmlStreamReader);
        OMElement documentElement = builder.getDocumentElement();
        Iterator artifacts = documentElement.getChildrenWithName(new QName(ARTIFACT));
        while (artifacts.hasNext()) {
            OMElement artifact = (OMElement)artifacts.next();
            OMAttribute version = artifact.getAttribute(new QName(VERSION));
            if (version == null) continue;
            version.setAttributeValue(newVersion);
        }
        if (this.isInDryRunMode()) {
            artifactXml = new File(artifactXml.getPath() + this.getDryRunFilePrefix());
        }
        File artifactXmlTemp = new File(artifactXml.getParentFile().getPath(), ARTIFACT_XML_TMP_FILE);
        FileOutputStream outputStream = new FileOutputStream(artifactXmlTemp);
        XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream);
        builder.getDocument().serialize(xmlStreamWriter);
        String artifactXmlPath = artifactXml.getPath();
        artifactXml.delete();
        artifactXmlTemp.renameTo(new File(artifactXmlPath));
        ((InputStream)inputStream).close();
        xmlStreamReader.close();
        outputStream.close();
        xmlStreamWriter.flush();
        xmlStreamWriter.close();
    }

    protected boolean isInDryRunMode() {
        File projectBaseDir = this.mavenProject.getBasedir();
        File dryRunPomFile = new File(projectBaseDir, POM_XML + this.getDryRunFilePrefix());
        return dryRunPomFile.exists();
    }

    protected MojoExecutor.Element[] getScmPluginProperties(File parentProjectBaseDir) {
        if (this.releaseProperties.containsKey(PROP_SCM_USERNAME)) {
            this.log.debug((CharSequence)"SCM credentials are found in release.properties file.");
            return new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)PARAMETER_BASEDIR), (String)parentProjectBaseDir.getAbsolutePath()), MojoExecutor.element((String)MojoExecutor.name((String)PARAMETER_MESSAGE), (String)("[wso2-release-plugin] " + this.getCommitMessage(this.releaseProperties).trim())), MojoExecutor.element((String)MojoExecutor.name((String)PARAM_INCLUDES), (String)ARTIFACT_XML_REGEX), MojoExecutor.element((String)MojoExecutor.name((String)PARAM_USERNAME), (String)this.releaseProperties.getProperty(PROP_SCM_USERNAME)), MojoExecutor.element((String)MojoExecutor.name((String)PARAM_PASSWORD), (String)this.releaseProperties.getProperty(PROP_SCM_PASSWORD))};
        }
        this.log.debug((CharSequence)"SCM credentials are not found in release.properties file.");
        return new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)PARAMETER_BASEDIR), (String)parentProjectBaseDir.getAbsolutePath()), MojoExecutor.element((String)MojoExecutor.name((String)PARAMETER_MESSAGE), (String)("[wso2-release-plugin] " + this.getCommitMessage(this.releaseProperties).trim())), MojoExecutor.element((String)MojoExecutor.name((String)PARAM_INCLUDES), (String)ARTIFACT_XML_REGEX)};
    }

    protected MavenProject getMavenProject(File pomFile) throws IOException, XmlPullParserException {
        MavenXpp3Reader xpp3Reader = new MavenXpp3Reader();
        FileReader reader = new FileReader(pomFile);
        Model model = xpp3Reader.read((Reader)reader);
        return new MavenProject(model);
    }

    class ArtifactXMLFilter
    implements IOFileFilter {
        ArtifactXMLFilter() {
        }

        public boolean accept(File file) {
            return file.getPath().endsWith(AbstractMavenReleaseMojo.ARTIFACT_XML);
        }

        public boolean accept(File file, String name) {
            return name.endsWith(AbstractMavenReleaseMojo.ARTIFACT_XML);
        }
    }
}

