/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec.frames;

import io.netty.buffer.ByteBuf;
import org.wso2.broker.amqp.codec.frames.GeneralFrame;

public class ContentFrame
extends GeneralFrame {
    private final long length;
    private final ByteBuf payload;

    public ContentFrame(int channel, long length, ByteBuf payload) {
        super((byte)3, channel);
        this.length = length;
        this.payload = payload;
    }

    @Override
    public long getPayloadSize() {
        return this.length;
    }

    @Override
    public void writePayload(ByteBuf buf) {
        buf.writeBytes(this.payload);
    }

    public static ContentFrame parse(ByteBuf buf, int channel, long payloadSize) {
        ByteBuf payload = buf.retainedSlice(buf.readerIndex(), (int)payloadSize);
        buf.skipBytes((int)payloadSize);
        return new ContentFrame(channel, payloadSize, payload);
    }
}

