/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec.frames;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.amqp.AmqpException;
import org.wso2.broker.amqp.codec.AmqpChannel;
import org.wso2.broker.amqp.codec.AmqpConnectionHandler;
import org.wso2.broker.amqp.codec.InMemoryMessageAggregator;
import org.wso2.broker.amqp.codec.frames.GeneralFrame;
import org.wso2.broker.core.BrokerException;
import org.wso2.broker.core.Message;

public class ContentFrame
extends GeneralFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentFrame.class);
    private final long length;
    private final ByteBuf payload;

    public ContentFrame(int channel, long length, ByteBuf payload) {
        super((byte)3, channel);
        this.length = length;
        this.payload = payload;
    }

    @Override
    public long getPayloadSize() {
        return this.length;
    }

    @Override
    public void writePayload(ByteBuf buf) {
        try {
            buf.writeBytes(this.payload);
        }
        finally {
            this.payload.release();
        }
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        boolean allContentReceived;
        AmqpChannel channel = connectionHandler.getChannel(this.getChannel());
        InMemoryMessageAggregator messageAggregator = channel.getMessageAggregator();
        try {
            allContentReceived = messageAggregator.contentBodyReceived(this.length, this.payload);
        }
        catch (AmqpException e) {
            LOGGER.warn("Content receiving failed", (Throwable)e);
            return;
        }
        if (allContentReceived) {
            Message message = messageAggregator.popMessage();
            ctx.fireChannelRead(() -> {
                try {
                    messageAggregator.publish(message);
                }
                catch (BrokerException e) {
                    LOGGER.warn("Content receiving failed", (Throwable)e);
                }
            });
        }
    }

    public static ContentFrame parse(ByteBuf buf, int channel, long payloadSize) {
        ByteBuf payload = buf.retainedSlice(buf.readerIndex(), (int)payloadSize);
        buf.skipBytes((int)payloadSize);
        return new ContentFrame(channel, payloadSize, payload);
    }
}

