/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec.frames;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.wso2.broker.amqp.codec.AmqpConnectionHandler;
import org.wso2.broker.amqp.codec.frames.AmqMethodBodyFactory;
import org.wso2.broker.amqp.codec.frames.MethodFrame;

public class ConnectionTuneOk
extends MethodFrame {
    private final int channelMax;
    private final long frameMax;
    private final int heartbeat;

    public ConnectionTuneOk(int channelMax, long frameMax, int heartbeat) {
        super(0, (short)10, (short)30);
        this.channelMax = channelMax;
        this.frameMax = frameMax;
        this.heartbeat = heartbeat;
    }

    @Override
    protected long getMethodBodySize() {
        return 8L;
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        buf.writeShort(this.channelMax);
        buf.writeInt((int)this.frameMax);
        buf.writeShort(this.heartbeat);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            int channelMax = buf.readUnsignedShort();
            long frameMax = buf.readUnsignedInt();
            int heartbeat = buf.readUnsignedShort();
            return new ConnectionTuneOk(channelMax, frameMax, heartbeat);
        };
    }
}

