/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec.frames;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.wso2.broker.amqp.codec.AmqpConnectionHandler;
import org.wso2.broker.amqp.codec.frames.AmqMethodBodyFactory;
import org.wso2.broker.amqp.codec.frames.ConnectionTune;
import org.wso2.broker.amqp.codec.frames.MethodFrame;
import org.wso2.broker.common.data.types.FieldTable;
import org.wso2.broker.common.data.types.LongString;
import org.wso2.broker.common.data.types.ShortString;

public class ConnectionStartOk
extends MethodFrame {
    private final FieldTable clientProperties;
    private final ShortString mechanisms;
    private final ShortString locales;
    private final LongString response;

    public ConnectionStartOk(int channel, FieldTable clientProperties, ShortString mechanisms, ShortString locales, LongString response) {
        super(channel, (short)10, (short)11);
        this.clientProperties = clientProperties;
        this.mechanisms = mechanisms;
        this.locales = locales;
        this.response = response;
    }

    @Override
    protected long getMethodBodySize() {
        return this.clientProperties.getSize() + this.mechanisms.getSize() + this.locales.getSize() + this.response.getSize();
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        this.clientProperties.write(buf);
        this.mechanisms.write(buf);
        this.locales.write(buf);
        this.response.write(buf);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        ctx.writeAndFlush((Object)new ConnectionTune(256, 65535L, 0));
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            FieldTable clientProperties = FieldTable.parse((ByteBuf)buf);
            ShortString mechanisms = ShortString.parse((ByteBuf)buf);
            LongString response = LongString.parse((ByteBuf)buf);
            ShortString locale = ShortString.parse((ByteBuf)buf);
            return new ConnectionStartOk(channel, clientProperties, mechanisms, locale, response);
        };
    }
}

