/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import org.wso2.broker.amqp.AmqpServerConfiguration;
import org.wso2.broker.amqp.codec.AmqpConnectionHandler;
import org.wso2.broker.amqp.codec.AmqpDecoder;
import org.wso2.broker.amqp.codec.AmqpEncoder;
import org.wso2.broker.amqp.codec.AmqpMessageWriter;
import org.wso2.broker.amqp.codec.BlockingTaskHandler;
import org.wso2.broker.core.Broker;

public class Server {
    private static final int BLOCKING_TASK_EXECUTOR_THREADS = 32;
    private final int port;
    private final Broker broker;
    private final String hostname;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private EventExecutorGroup ioExecutors;
    private Channel serverChannel;

    public Server(Broker broker, AmqpServerConfiguration configuration) {
        this.hostname = configuration.getNonSecure().getHostName();
        this.port = Integer.parseInt(configuration.getNonSecure().getPort());
        this.broker = broker;
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        this.ioExecutors = new DefaultEventExecutorGroup(32);
    }

    public void run() throws InterruptedException {
        try {
            ChannelFuture f = this.bindToSocket();
            f.channel().closeFuture().sync();
        }
        finally {
            this.shutdownExecutors();
        }
    }

    private void shutdownExecutors() {
        this.workerGroup.shutdownGracefully();
        this.bossGroup.shutdownGracefully();
        this.ioExecutors.shutdownGracefully();
    }

    private ChannelFuture bindToSocket() throws InterruptedException {
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new SocketChannelInitializer(this.ioExecutors)).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        return b.bind(this.hostname, this.port).sync();
    }

    public void start() throws InterruptedException {
        ChannelFuture channelFuture = this.bindToSocket();
        this.serverChannel = channelFuture.channel();
    }

    public void stop() throws InterruptedException {
        try {
            this.serverChannel.close().sync();
        }
        finally {
            this.shutdownExecutors();
        }
    }

    private class SocketChannelInitializer
    extends ChannelInitializer<SocketChannel> {
        private final EventExecutorGroup ioExecutors;

        public SocketChannelInitializer(EventExecutorGroup ioExecutors) {
            this.ioExecutors = ioExecutors;
        }

        protected void initChannel(SocketChannel socketChannel) {
            socketChannel.pipeline().addLast(new ChannelHandler[]{new AmqpDecoder()}).addLast(new ChannelHandler[]{new AmqpEncoder()}).addLast(new ChannelHandler[]{new AmqpConnectionHandler(Server.this.broker)}).addLast(new ChannelHandler[]{new AmqpMessageWriter()}).addLast(this.ioExecutors, new ChannelHandler[]{new BlockingTaskHandler()});
        }
    }
}

