/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec.frames;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.wso2.broker.amqp.AmqpException;
import org.wso2.broker.amqp.codec.AmqpChannel;
import org.wso2.broker.amqp.codec.AmqpConnectionHandler;
import org.wso2.broker.amqp.codec.frames.AmqMethodBodyFactory;
import org.wso2.broker.amqp.codec.frames.BasicCancelOk;
import org.wso2.broker.amqp.codec.frames.MethodFrame;
import org.wso2.broker.common.data.types.ShortString;

public class BasicCancel
extends MethodFrame {
    private final ShortString consumerTag;
    private final boolean noWait;

    public BasicCancel(int channel, ShortString consumerTag, boolean noWait) {
        super(channel, (short)60, (short)30);
        this.consumerTag = consumerTag;
        this.noWait = noWait;
    }

    @Override
    protected long getMethodBodySize() {
        return this.consumerTag.getSize() + 1L;
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        this.consumerTag.write(buf);
        buf.writeBoolean(this.noWait);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        AmqpChannel channel = connectionHandler.getChannel(this.getChannel());
        ctx.fireChannelRead(() -> {
            try {
                channel.cancelConsumer(this.consumerTag);
                ctx.writeAndFlush((Object)new BasicCancelOk(this.getChannel(), this.consumerTag));
            }
            catch (AmqpException amqpException) {
                // empty catch block
            }
        });
    }

    public ShortString getConsumerTag() {
        return this.consumerTag;
    }

    public boolean isNoWait() {
        return this.noWait;
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            ShortString consumerTag = ShortString.parse((ByteBuf)buf);
            boolean noWait = buf.readBoolean();
            return new BasicCancel(channel, consumerTag, noWait);
        };
    }
}

