/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec.frames;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.amqp.codec.AmqpChannel;
import org.wso2.broker.amqp.codec.AmqpConnectionHandler;
import org.wso2.broker.amqp.codec.InMemoryMessageAggregator;
import org.wso2.broker.amqp.codec.frames.GeneralFrame;
import org.wso2.broker.common.data.types.EncodableData;
import org.wso2.broker.common.data.types.FieldTable;
import org.wso2.broker.common.data.types.ShortString;
import org.wso2.broker.core.Metadata;

public class HeaderFrame
extends GeneralFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeaderFrame.class);
    private static final short BYTE_DEFAULT = -1;
    private static final long LONG_DEFAULT = -1L;
    private static final int CONTENT_TYPE_MASK = 32768;
    private static final int ENCODING_MASK = 16384;
    private static final int HEADERS_MASK = 8192;
    private static final int DELIVERY_MODE_MASK = 4096;
    private static final int PRIORITY_MASK = 2048;
    private static final int CORRELATION_ID_MASK = 1024;
    private static final int REPLY_TO_MASK = 512;
    private static final int EXPIRATION_MASK = 256;
    private static final int MESSAGE_ID_MASK = 128;
    private static final int TIMESTAMP_MASK = 64;
    private static final int TYPE_MASK = 32;
    private static final int USER_ID_MASK = 16;
    private static final int APPLICATION_ID_MASK = 8;
    private static final int LAST_BIT_MASK = 1;
    private final long bodySize;
    private final int classId;
    private ShortString contentType;
    private ShortString contentEncoding;
    private FieldTable headers;
    private short deliveryMode = (short)-1;
    private short priority = (short)-1;
    private ShortString correlationId;
    private ShortString replyTo;
    private ShortString expiration;
    private ShortString messageId;
    private long timestamp = -1L;
    private ShortString type;
    private ShortString userId;
    private ShortString appId;
    private int propertyFlags = 0;
    private ByteBuf rawMetadata;

    public HeaderFrame(int channel, int classId, long bodySize) {
        super((byte)2, channel);
        this.classId = classId;
        this.bodySize = bodySize;
        this.rawMetadata = null;
    }

    @Override
    public long getPayloadSize() {
        if (this.rawMetadata != null) {
            return this.rawMetadata.capacity();
        }
        long propertyListSize = 0L;
        propertyListSize += this.getPropertySize((EncodableData)this.contentType);
        propertyListSize += this.getPropertySize((EncodableData)this.contentEncoding);
        propertyListSize += this.getPropertySize((EncodableData)this.headers);
        propertyListSize += this.getPropertySize(this.deliveryMode);
        propertyListSize += this.getPropertySize(this.priority);
        propertyListSize += this.getPropertySize((EncodableData)this.correlationId);
        propertyListSize += this.getPropertySize((EncodableData)this.replyTo);
        propertyListSize += this.getPropertySize((EncodableData)this.expiration);
        propertyListSize += this.getPropertySize((EncodableData)this.messageId);
        propertyListSize += this.getPropertySize(this.timestamp);
        propertyListSize += this.getPropertySize((EncodableData)this.type);
        propertyListSize += this.getPropertySize((EncodableData)this.userId);
        return 14L + (propertyListSize += this.getPropertySize((EncodableData)this.appId));
    }

    private long getPropertySize(long property) {
        if (property != -1L) {
            return 8L;
        }
        return 0L;
    }

    private long getPropertySize(short property) {
        if (property != -1) {
            return 1L;
        }
        return 0L;
    }

    private long getPropertySize(EncodableData property) {
        if (property != null) {
            return property.getSize();
        }
        return 0L;
    }

    @Override
    public void writePayload(ByteBuf buf) {
        if (this.rawMetadata == null) {
            buf.writeShort(this.classId);
            buf.writeShort(0);
            buf.writeLong(this.bodySize);
            buf.writeShort(this.propertyFlags);
            this.writeProperty(buf, (EncodableData)this.contentType);
            this.writeProperty(buf, (EncodableData)this.contentEncoding);
            this.writeProperty(buf, (EncodableData)this.headers);
            this.writeProperty(buf, this.deliveryMode);
            this.writeProperty(buf, this.priority);
            this.writeProperty(buf, (EncodableData)this.correlationId);
            this.writeProperty(buf, (EncodableData)this.replyTo);
            this.writeProperty(buf, (EncodableData)this.expiration);
            this.writeProperty(buf, (EncodableData)this.messageId);
            this.writeProperty(buf, this.timestamp);
            this.writeProperty(buf, (EncodableData)this.type);
            this.writeProperty(buf, (EncodableData)this.userId);
            this.writeProperty(buf, (EncodableData)this.appId);
        } else {
            try {
                buf.writeBytes(this.rawMetadata);
            }
            finally {
                this.rawMetadata.release();
            }
        }
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        AmqpChannel channel = connectionHandler.getChannel(this.getChannel());
        InMemoryMessageAggregator inMemoryMessageAggregator = channel.getMessageAggregator();
        inMemoryMessageAggregator.headerFrameReceived(this.rawMetadata, this.bodySize, (byteBuf, metadata) -> {
            try {
                this.parse((ByteBuf)byteBuf, (Metadata)metadata);
                return true;
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while parsing metadata headers", (Throwable)e);
                return false;
            }
        });
    }

    private void writeProperty(ByteBuf buf, long property) {
        if (property != -1L) {
            buf.writeLong(property);
        }
    }

    private void writeProperty(ByteBuf buf, EncodableData property) {
        if (property != null) {
            property.write(buf);
        }
    }

    private void writeProperty(ByteBuf buf, int property) {
        if (property != -1) {
            buf.writeByte(property);
        }
    }

    public Metadata parse(ByteBuf buf, Metadata metadata) throws Exception {
        boolean hasMoreProperties;
        buf.markReaderIndex();
        buf.skipBytes(12);
        int propertyFlags = buf.readUnsignedShort();
        boolean bl = hasMoreProperties = (propertyFlags & 1) != 0;
        while (hasMoreProperties) {
            int otherPropertyFlags = buf.readUnsignedShort();
            hasMoreProperties = (otherPropertyFlags & 1) != 0;
        }
        if ((propertyFlags & 0x8000) != 0) {
            metadata.setContentType(ShortString.parse((ByteBuf)buf));
        }
        if ((propertyFlags & 0x4000) != 0) {
            metadata.setContentEncoding(ShortString.parse((ByteBuf)buf));
        }
        if ((propertyFlags & 0x2000) != 0) {
            metadata.setHeaders(FieldTable.parse((ByteBuf)buf));
        }
        if ((propertyFlags & 0x1000) != 0) {
            metadata.setDeliveryMode(buf.readUnsignedByte());
        }
        if ((propertyFlags & 0x800) != 0) {
            metadata.setPriority(buf.readUnsignedByte());
        }
        if ((propertyFlags & 0x400) != 0) {
            metadata.setCorrelationId(ShortString.parse((ByteBuf)buf));
        }
        if ((propertyFlags & 0x200) != 0) {
            metadata.setReplyTo(ShortString.parse((ByteBuf)buf));
        }
        if ((propertyFlags & 0x100) != 0) {
            metadata.setExpiration(ShortString.parse((ByteBuf)buf));
        }
        if ((propertyFlags & 0x80) != 0) {
            metadata.setMessageId(ShortString.parse((ByteBuf)buf));
        }
        if ((propertyFlags & 0x40) != 0) {
            metadata.setTimestamp(buf.readLong());
        }
        if ((propertyFlags & 0x20) != 0) {
            metadata.setType(ShortString.parse((ByteBuf)buf));
        }
        if ((propertyFlags & 0x10) != 0) {
            metadata.setUserId(ShortString.parse((ByteBuf)buf));
        }
        if ((propertyFlags & 8) != 0) {
            metadata.setAppId(ShortString.parse((ByteBuf)buf));
        }
        buf.resetReaderIndex();
        return metadata;
    }

    public static HeaderFrame lazyParse(ByteBuf buf, int channelId, long payloadSize) {
        buf.markReaderIndex();
        int classId = buf.readUnsignedShort();
        buf.skipBytes(2);
        long bodySize = buf.readLong();
        HeaderFrame headerFrame = new HeaderFrame(channelId, classId, bodySize);
        buf.resetReaderIndex();
        ByteBuf metadata = buf.retainedSlice(buf.readerIndex(), (int)payloadSize);
        buf.skipBytes((int)payloadSize);
        headerFrame.setRawMetadata(metadata);
        return headerFrame;
    }

    public void setContentType(ShortString contentType) {
        this.propertyFlags |= 0x8000;
        this.contentType = contentType;
    }

    public void setContentEncoding(ShortString contentEncoding) {
        this.propertyFlags |= 0x4000;
        this.contentEncoding = contentEncoding;
    }

    public void setHeaders(FieldTable headers) {
        this.propertyFlags |= 0x2000;
        this.headers = headers;
    }

    public void setDeliveryMode(short deliveryMode) {
        this.propertyFlags |= 0x1000;
        this.deliveryMode = deliveryMode;
    }

    public void setPriority(short priority) {
        this.propertyFlags |= 0x800;
        this.priority = priority;
    }

    public void setCorrelationId(ShortString correlationId) {
        this.propertyFlags |= 0x400;
        this.correlationId = correlationId;
    }

    public void setReplyTo(ShortString replyTo) {
        this.propertyFlags |= 0x200;
        this.replyTo = replyTo;
    }

    public void setExpiration(ShortString expiration) {
        this.propertyFlags |= 0x100;
        this.expiration = expiration;
    }

    public void setMessageId(ShortString messageId) {
        this.propertyFlags |= 0x80;
        this.messageId = messageId;
    }

    public void setTimestamp(long timestamp) {
        this.propertyFlags |= 0x40;
        this.timestamp = timestamp;
    }

    public void setType(ShortString type) {
        this.propertyFlags |= 0x20;
        this.type = type;
    }

    public void setUserId(ShortString userId) {
        this.propertyFlags |= 0x10;
        this.userId = userId;
    }

    public void setAppId(ShortString appId) {
        this.propertyFlags |= 8;
        this.appId = appId;
    }

    public void setRawMetadata(ByteBuf rawMetadata) {
        this.rawMetadata = rawMetadata;
    }
}

