/*
 * Copyright (c) 2017, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

package org.wso2.broker.amqp.codec.handlers;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import org.wso2.broker.amqp.AmqpDeliverMessage;

import java.util.List;

/**
 * Writes {@link AmqpDeliverMessage} to the outbound channel
 */
public class AmqpMessageWriter extends ChannelOutboundHandlerAdapter {

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof AmqpDeliverMessage) {
            ((AmqpDeliverMessage) msg).write(ctx);
        } else  {
            ctx.write(msg, promise);
        }
    }

    public static void write(Channel channel, List<AmqpDeliverMessage> pendingMessages) {
        for (AmqpDeliverMessage message : pendingMessages) {
            channel.write(message);
        }
    }
}
