/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec.handlers;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.CharsetUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.amqp.codec.frames.AmqMethodBodyFactory;
import org.wso2.broker.amqp.codec.frames.AmqMethodRegistry;
import org.wso2.broker.amqp.codec.frames.AmqpBadMessage;
import org.wso2.broker.amqp.codec.frames.ContentFrame;
import org.wso2.broker.amqp.codec.frames.GeneralFrame;
import org.wso2.broker.amqp.codec.frames.HeaderFrame;
import org.wso2.broker.amqp.codec.frames.ProtocolInitFrame;

public class AmqpDecoder
extends ByteToMessageDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpDecoder.class);
    private static final AmqMethodRegistry methodRegistry = new AmqMethodRegistry();
    private static final int FRAME_SIZE_WITHOUT_PAYLOAD = 8;
    private static final CharSequence AMQP_PROTOCOL_IDENTIFIER = "AMQP";
    private static final int MIN_HEADER_FRAME_SIZE = 14;
    private State currentState = State.PROTOCOL_INITIALIZATION;

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        switch (this.currentState) {
            case PROTOCOL_INITIALIZATION: {
                this.processProtocolInitFrame(buffer, out);
                this.currentState = State.READ_FRAME;
                return;
            }
            case READ_FRAME: {
                this.parseFrame(buffer, out);
                return;
            }
            case BAD_MESSAGE: {
                buffer.skipBytes(this.actualReadableBytes());
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    private void processProtocolInitFrame(ByteBuf buffer, List<Object> out) {
        if (buffer.readableBytes() >= 8) {
            CharSequence protocolName = buffer.readCharSequence(4, CharsetUtil.US_ASCII);
            buffer.skipBytes(1);
            byte majorVersion = buffer.readByte();
            byte minorVersion = buffer.readByte();
            byte revision = buffer.readByte();
            if (!AMQP_PROTOCOL_IDENTIFIER.equals(protocolName)) {
                out.add(new AmqpBadMessage(new IllegalArgumentException("Unknown protocol name " + protocolName.toString())));
                this.currentState = State.BAD_MESSAGE;
            }
            out.add(new ProtocolInitFrame(majorVersion, minorVersion, revision));
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOGGER.warn("Exception while handling request", cause);
        this.currentState = State.BAD_MESSAGE;
        ctx.close();
    }

    private void parseFrame(ByteBuf buffer, List<Object> out) throws Exception {
        buffer.markReaderIndex();
        if (buffer.readableBytes() > 8) {
            byte type = buffer.readByte();
            short channel = buffer.readShort();
            long payloadSize = buffer.readInt();
            long estimatedRemainingSize = payloadSize + 1L;
            if ((long)buffer.readableBytes() < estimatedRemainingSize) {
                buffer.resetReaderIndex();
                return;
            }
            GeneralFrame frame = null;
            switch (type) {
                case 1: {
                    short amqpClass = buffer.readShort();
                    short amqpMethod = buffer.readShort();
                    AmqMethodBodyFactory factory = methodRegistry.getFactory(amqpClass, amqpMethod);
                    frame = factory.newInstance(buffer, channel, payloadSize);
                    break;
                }
                case 2: {
                    frame = HeaderFrame.parse(buffer, channel);
                    break;
                }
                case 3: {
                    frame = ContentFrame.parse(buffer, channel, payloadSize);
                    break;
                }
                case 4: {
                    throw new Exception("Method Not implemented");
                }
            }
            byte frameEnd = buffer.readByte();
            if (frameEnd != -50) {
                throw new Exception("Invalid AMQP frame");
            }
            out.add(frame);
        }
    }

    private static enum State {
        PROTOCOL_INITIALIZATION,
        READ_FRAME,
        BAD_MESSAGE;

    }
}

