/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.auth.authentication.authenticator.impl;

import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.wso2.broker.auth.BrokerAuthConfiguration;
import org.wso2.broker.auth.BrokerAuthException;
import org.wso2.broker.auth.authentication.authenticator.Authenticator;
import org.wso2.broker.auth.authentication.sasl.plain.PlainSaslCallbackHandler;
import org.wso2.broker.auth.user.UserStoreManager;
import org.wso2.broker.common.BrokerConfigProvider;
import org.wso2.broker.common.StartupContext;

public class JaasAuthenticator
implements Authenticator {
    @Override
    public void initialize(StartupContext startupContext) throws Exception {
        UserStoreManager userStoreManager = (UserStoreManager)startupContext.getService(UserStoreManager.class);
        BrokerConfigProvider configProvider = (BrokerConfigProvider)startupContext.getService(BrokerConfigProvider.class);
        BrokerAuthConfiguration brokerAuthConfiguration = (BrokerAuthConfiguration)configProvider.getConfigurationObject("wso2.broker.auth", BrokerAuthConfiguration.class);
        BrokerAuthConfiguration.JaasConfiguration jaasConf = brokerAuthConfiguration.getAuthentication().getJaas();
        String jaasConfigPath = System.getProperty("java.auth.auth.login.config");
        if (jaasConfigPath == null || jaasConfigPath.trim().isEmpty()) {
            Configuration jaasConfig = JaasAuthenticator.createJaasConfig(jaasConf.getLoginModule(), userStoreManager, jaasConf.getOptions());
            Configuration.setConfiguration(jaasConfig);
        }
    }

    @Override
    public boolean authenticate(String username, char[] credentials) throws BrokerAuthException {
        try {
            PlainSaslCallbackHandler plainCallbackHandler = new PlainSaslCallbackHandler();
            plainCallbackHandler.setUsername(username);
            plainCallbackHandler.setPassword(credentials);
            LoginContext loginContext = new LoginContext("BrokerSecurityConfig", plainCallbackHandler);
            loginContext.login();
            return true;
        }
        catch (LoginException e) {
            throw new BrokerAuthException("Error while authenticating user with login module", e);
        }
    }

    private static Configuration createJaasConfig(String loginModuleClassName, UserStoreManager userStoreManager, Map<String, Object> options) {
        options.put("UserStoreManagerImpl", userStoreManager);
        final AppConfigurationEntry[] entries = new AppConfigurationEntry[]{new AppConfigurationEntry(loginModuleClassName, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                return entries;
            }
        };
    }
}

