/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.coordination.rdbms;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.coordination.CoordinationException;
import org.wso2.broker.coordination.rdbms.MembershipEvent;
import org.wso2.broker.coordination.rdbms.RdbmsCoordinationDaoImpl;
import org.wso2.broker.coordination.rdbms.RdbmsMembershipListener;

class MembershipListenerTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(MembershipListenerTask.class);
    private RdbmsCoordinationDaoImpl coordinationDao;
    private String nodeID;
    private List<RdbmsMembershipListener> listeners;

    MembershipListenerTask(String nodeId, RdbmsCoordinationDaoImpl coordinationDao) {
        this.nodeID = nodeId;
        this.coordinationDao = coordinationDao;
        this.listeners = new ArrayList<RdbmsMembershipListener>();
    }

    @Override
    public void run() {
        try {
            List<MembershipEvent> membershipEvents = this.readMembershipEvents();
            if (!membershipEvents.isEmpty()) {
                block7: for (MembershipEvent event : membershipEvents) {
                    switch (event.getMembershipEventType()) {
                        case MEMBER_ADDED: {
                            this.notifyMemberAddition(event.getMember());
                            continue block7;
                        }
                        case MEMBER_REMOVED: {
                            this.notifyMemberRemoval(event.getMember());
                            continue block7;
                        }
                        case COORDINATOR_CHANGED: {
                            this.notifyCoordinatorChangeEvent(event.getMember());
                            continue block7;
                        }
                    }
                    logger.error("Unknown cluster event type: " + (Object)((Object)event.getMembershipEventType()));
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("No membership events to sync");
            }
        }
        catch (Throwable e) {
            logger.warn("Error occurred while reading membership events.", e);
        }
    }

    private void notifyCoordinatorChangeEvent(String member) {
        for (RdbmsMembershipListener listener : this.listeners) {
            listener.coordinatorChanged(member);
        }
    }

    private void notifyMemberRemoval(String member) {
        for (RdbmsMembershipListener listener : this.listeners) {
            listener.memberRemoved(member);
        }
    }

    private void notifyMemberAddition(String member) {
        for (RdbmsMembershipListener listener : this.listeners) {
            listener.memberAdded(member);
        }
    }

    private List<MembershipEvent> readMembershipEvents() throws CoordinationException {
        return this.coordinationDao.readMembershipEvents(this.nodeID);
    }

    void addEventListener(RdbmsMembershipListener membershipListener) {
        this.listeners.add(membershipListener);
    }

    void removeEventListener(RdbmsMembershipListener membershipListener) {
        this.listeners.remove(membershipListener);
    }
}

