/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.coordination.rdbms;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.coordination.CoordinationException;
import org.wso2.broker.coordination.rdbms.MembershipEventType;
import org.wso2.broker.coordination.rdbms.MembershipListenerTask;
import org.wso2.broker.coordination.rdbms.RdbmsCoordinationDaoImpl;
import org.wso2.broker.coordination.rdbms.RdbmsMembershipListener;

public class RdbmsMembershipEventingEngine {
    private static final Logger logger = LoggerFactory.getLogger(RdbmsMembershipEventingEngine.class);
    private RdbmsCoordinationDaoImpl coordinationDao;
    private ScheduledExecutorService clusterMembershipReaderTaskScheduler;
    private MembershipListenerTask membershipListenerTask;

    public RdbmsMembershipEventingEngine(RdbmsCoordinationDaoImpl coordinationDao) {
        this.coordinationDao = coordinationDao;
    }

    public void start(String nodeId, int eventPollingInterval) {
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("ClusterEventReaderTask-%d").build();
        this.clusterMembershipReaderTaskScheduler = Executors.newSingleThreadScheduledExecutor(namedThreadFactory);
        this.membershipListenerTask = new MembershipListenerTask(nodeId, this.coordinationDao);
        this.clusterMembershipReaderTaskScheduler.scheduleWithFixedDelay(this.membershipListenerTask, eventPollingInterval, eventPollingInterval, TimeUnit.MILLISECONDS);
        logger.info("RDBMS cluster event listener started.");
    }

    public void stop() {
        this.clusterMembershipReaderTaskScheduler.shutdown();
    }

    public void notifyMembershipEvent(List<String> nodes, MembershipEventType membershipEventType, String nodeID) throws CoordinationException {
        this.coordinationDao.storeMembershipEvent(nodes, membershipEventType.getCode(), nodeID);
    }

    public void addEventListener(RdbmsMembershipListener membershipListener) {
        this.membershipListenerTask.addEventListener(membershipListener);
    }

    public void removeEventListener(RdbmsMembershipListener membershipListener) {
        this.membershipListenerTask.removeEventListener(membershipListener);
    }
}

