/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.coordination.rdbms;

import javax.sql.DataSource;
import org.wso2.broker.common.StartupContext;
import org.wso2.broker.coordination.AbstractHaStrategy;
import org.wso2.broker.coordination.BrokerHaConfiguration;
import org.wso2.broker.coordination.rdbms.RdbmsCoordinationDaoImpl;
import org.wso2.broker.coordination.rdbms.RdbmsCoordinationListener;
import org.wso2.broker.coordination.rdbms.RdbmsCoordinationStrategy;

public class RdbmsHaStrategy
extends AbstractHaStrategy
implements RdbmsCoordinationListener {
    private RdbmsCoordinationStrategy rdbmsCoordinationStrategy;

    @Override
    public void setup(StartupContext startupContext) throws Exception {
        DataSource dataSource = (DataSource)startupContext.getService(DataSource.class);
        BrokerHaConfiguration brokerHaConfiguration = (BrokerHaConfiguration)startupContext.getService(BrokerHaConfiguration.class);
        this.rdbmsCoordinationStrategy = new RdbmsCoordinationStrategy(new RdbmsCoordinationDaoImpl(dataSource), brokerHaConfiguration.getOptions());
        this.rdbmsCoordinationStrategy.addCoordinationListener(this);
    }

    @Override
    public void start() {
        this.rdbmsCoordinationStrategy.start();
    }

    @Override
    public boolean isActiveNode() {
        return this.rdbmsCoordinationStrategy.isCoordinator();
    }

    @Override
    public void stop() {
        super.stop();
        this.rdbmsCoordinationStrategy.stop();
    }

    public void pause() {
        this.rdbmsCoordinationStrategy.pause();
    }

    public void resume() {
        this.rdbmsCoordinationStrategy.resume();
    }

    @Override
    public void becameCoordinatorNode() {
        this.notifyBecameActiveNode();
    }

    @Override
    public void lostCoordinatorState() {
        this.notifyBecamePassiveNode();
    }
}

