/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.coordination;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.common.BrokerConfigProvider;
import org.wso2.broker.common.StartupContext;
import org.wso2.broker.coordination.BrokerHaConfiguration;
import org.wso2.broker.coordination.HaStrategy;

public class HaStrategyFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(HaStrategyFactory.class);

    public static HaStrategy getHaStrategy(StartupContext startupContext) throws Exception {
        BrokerConfigProvider brokerConfigProvider = (BrokerConfigProvider)startupContext.getService(BrokerConfigProvider.class);
        BrokerHaConfiguration brokerHaConfiguration = (BrokerHaConfiguration)brokerConfigProvider.getConfigurationObject("wso2.broker.failover", BrokerHaConfiguration.class);
        startupContext.registerService(BrokerHaConfiguration.class, (Object)brokerHaConfiguration);
        if (!brokerHaConfiguration.isEnabled()) {
            return null;
        }
        String haStrategyClass = brokerHaConfiguration.getStrategy();
        LOGGER.info("Initializing HA Strategy: {}", (Object)haStrategyClass);
        HaStrategy haStrategy = (HaStrategy)ClassLoader.getSystemClassLoader().loadClass(haStrategyClass).newInstance();
        haStrategy.setup(startupContext);
        return haStrategy;
    }
}

