/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.rest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.common.BrokerConfigProvider;
import org.wso2.broker.common.StartupContext;
import org.wso2.broker.rest.BrokerServiceRunner;
import org.wso2.broker.rest.config.RestServerConfiguration;
import org.wso2.msf4j.MicroservicesRunner;

public class BrokerRestServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BrokerRestServer.class);
    private final MicroservicesRunner microservicesRunner;

    public BrokerRestServer(StartupContext context) throws Exception {
        BrokerConfigProvider configProvider = (BrokerConfigProvider)context.getService(BrokerConfigProvider.class);
        RestServerConfiguration configuration = (RestServerConfiguration)configProvider.getConfigurationObject("admin.service", RestServerConfiguration.class);
        int port = Integer.parseInt(configuration.getPlain().getPort());
        this.microservicesRunner = new MicroservicesRunner(new int[]{port});
        context.registerService(BrokerServiceRunner.class, (Object)new BrokerServiceRunner(this.microservicesRunner));
    }

    public void start() {
        this.microservicesRunner.start();
        LOGGER.info("Broker rest server started");
    }

    public void stop() {
        this.microservicesRunner.stop();
        LOGGER.info("Broker rest server stopped");
    }
}

