/*
 * Decompiled with CFR 0.152.
 */
package com.wso2.jwt.token.builder.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;

public class JWTAccessTokenBuilderDSComponent {
    private static Log log = LogFactory.getLog(JWTAccessTokenBuilderDSComponent.class);
    private static RealmService realmService;
    private static RegistryService registryService;

    private static synchronized void setStaticRealmService(RealmService realmService) {
        JWTAccessTokenBuilderDSComponent.realmService = realmService;
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    protected void setRealmService(RealmService realmService) {
        JWTAccessTokenBuilderDSComponent.setStaticRealmService(realmService);
        if (log.isDebugEnabled()) {
            log.debug((Object)"RealmService is set in the custom token builder bundle");
        }
    }

    private static synchronized void setStaticRegistryService(RegistryService registryService) {
        JWTAccessTokenBuilderDSComponent.registryService = registryService;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    protected void setRegistryService(RegistryService registryService) {
        JWTAccessTokenBuilderDSComponent.setStaticRegistryService(registryService);
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService is set in the custom token builder bundle");
        }
    }

    protected void activate(ComponentContext ctxt) {
        try {
            log.info((Object)"Custom token builder activated successfully.");
        }
        catch (Exception e) {
            log.error((Object)"Failed to activate custom token builder ", (Throwable)e);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Custom token builder is deactivated ");
        }
    }

    protected void unsetRealmService(RealmService realmService) {
        JWTAccessTokenBuilderDSComponent.setStaticRealmService(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"RealmService is unset in the custom token builder bundle");
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        JWTAccessTokenBuilderDSComponent.setStaticRegistryService(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService is unset in the custom token builder bundle");
        }
    }
}

