/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.spring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.wso2.msf4j.MicroservicesRunner;
import org.wso2.msf4j.internal.DataHolder;
import org.wso2.msf4j.spring.transport.HTTPSTransportConfig;
import org.wso2.msf4j.spring.transport.TransportConfig;
import org.wso2.transport.http.netty.common.Util;
import org.wso2.transport.http.netty.config.ListenerConfiguration;
import org.wso2.transport.http.netty.config.Parameter;
import org.wso2.transport.http.netty.contract.HttpWsConnectorFactory;
import org.wso2.transport.http.netty.contract.ServerConnector;
import org.wso2.transport.http.netty.contractimpl.HttpWsConnectorFactoryImpl;
import org.wso2.transport.http.netty.listener.ServerBootstrapConfiguration;

@Component
public class SpringMicroservicesRunner
extends MicroservicesRunner
implements ApplicationContextAware,
InitializingBean {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    @Autowired
    private ApplicationContext applicationContext;

    public SpringMicroservicesRunner() {
    }

    public SpringMicroservicesRunner(int ... ports) {
        super(ports);
    }

    public void init() {
        for (Map.Entry entry : this.applicationContext.getBeansWithAnnotation(Path.class).entrySet()) {
            this.log.info((Object)("Deploying " + (String)entry.getKey() + " bean as a resource"));
            this.deploy(new Object[]{entry.getValue()});
        }
        for (Map.Entry exceptionMapper : this.applicationContext.getBeansOfType(ExceptionMapper.class).entrySet()) {
            this.log.info((Object)("Adding " + (String)exceptionMapper.getKey() + "  ExceptionMapper"));
            this.addExceptionMapper(new ExceptionMapper[]{(ExceptionMapper)exceptionMapper.getValue()});
        }
        this.configureTransport(this.applicationContext.getBeansOfType(ListenerConfiguration.class).values(), this.applicationContext.getBeansOfType(TransportConfig.class).values());
        this.start();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    protected void configureTransport() {
    }

    protected void configureTransport(Collection<ListenerConfiguration> listeners, Collection<TransportConfig> transportConfigs) {
        if (System.getProperty("transports.netty.conf") != null) {
            super.configureTransport();
            return;
        }
        HttpWsConnectorFactoryImpl connectorFactory = new HttpWsConnectorFactoryImpl();
        ServerBootstrapConfiguration bootstrapConfiguration = ServerBootstrapConfiguration.getInstance();
        listeners.forEach(arg_0 -> this.lambda$configureTransport$0((HttpWsConnectorFactory)connectorFactory, bootstrapConfiguration, arg_0));
        for (TransportConfig transportConfig : transportConfigs) {
            if (!transportConfig.isEnabled()) continue;
            ListenerConfiguration listenerConfiguration = this.createListenerConfiguration(transportConfig);
            DataHolder.getInstance().getMicroservicesRegistries().put(Util.createServerConnectorID((String)listenerConfiguration.getHost(), (int)listenerConfiguration.getPort()), this.getMsRegistry());
            ServerConnector serverConnector = connectorFactory.createServerConnector(bootstrapConfiguration, listenerConfiguration);
            this.serverConnectors.add(serverConnector);
        }
    }

    private ListenerConfiguration createListenerConfiguration(TransportConfig transportConfig) {
        ListenerConfiguration listenerConfig = new ListenerConfiguration(transportConfig.getId(), transportConfig.getHost(), transportConfig.getPort());
        listenerConfig.setScheme(transportConfig.getScheme());
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (Map.Entry<String, String> entry : transportConfig.getParameters().entrySet()) {
            parameters.add(this.createParameter(entry.getKey(), entry.getValue()));
        }
        listenerConfig.setParameters(parameters);
        if ("https".equals(transportConfig.getScheme())) {
            HTTPSTransportConfig httpsTransportConfig = (HTTPSTransportConfig)transportConfig;
            listenerConfig.setKeyStoreFile(httpsTransportConfig.getKeyStoreFile());
            listenerConfig.setKeyStorePass(httpsTransportConfig.getKeyStorePass());
            listenerConfig.setCertPass(httpsTransportConfig.getCertPass());
        }
        return listenerConfig;
    }

    private Parameter createParameter(String key, String value) {
        Parameter parameter = new Parameter();
        parameter.setName(key);
        parameter.setValue(value);
        return parameter;
    }

    private /* synthetic */ void lambda$configureTransport$0(HttpWsConnectorFactory httpWsConnectorFactory, ServerBootstrapConfiguration serverBootstrapConfiguration, ListenerConfiguration listenerConfiguration) {
        DataHolder.getInstance().getMicroservicesRegistries().put(Util.createServerConnectorID((String)listenerConfiguration.getHost(), (int)listenerConfiguration.getPort()), this.getMsRegistry());
        ServerConnector serverConnector = httpWsConnectorFactory.createServerConnector(serverBootstrapConfiguration, listenerConfiguration);
        this.serverConnectors.add(serverConnector);
    }
}

