/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.config;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.wso2.carbon.transport.http.netty.common.Util;
import org.wso2.carbon.transport.http.netty.common.ssl.SSLConfig;
import org.wso2.carbon.transport.http.netty.config.Parameter;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class SenderConfiguration {
    public static final String DEFAULT_KEY = "netty";
    @XmlAttribute(required=true)
    private String id;
    @XmlAttribute
    private String scheme = "http";
    @XmlAttribute
    private String keyStoreFile;
    @XmlAttribute
    private String keyStorePass;
    @XmlAttribute
    private String trustStoreFile;
    @XmlAttribute
    private String trustStorePass;
    @XmlAttribute
    private String certPass;
    @XmlAttribute
    private int socketIdleTimeout;
    @XmlElementWrapper(name="parameters")
    @XmlElement(name="parameter")
    private List<Parameter> parameters;

    public static SenderConfiguration getDefault() {
        SenderConfiguration defaultConfig = new SenderConfiguration(DEFAULT_KEY);
        return defaultConfig;
    }

    public SenderConfiguration() {
    }

    public SenderConfiguration(String id) {
        this.id = id;
    }

    public String getCertPass() {
        return this.certPass;
    }

    public void setCertPass(String certPass) {
        this.certPass = certPass;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public String getKeyStorePass() {
        return this.keyStorePass;
    }

    public void setKeyStorePass(String keyStorePass) {
        this.keyStorePass = keyStorePass;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public String getTrustStoreFile() {
        return this.trustStoreFile;
    }

    public void setTrustStoreFile(String trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
    }

    public String getTrustStorePass() {
        return this.trustStorePass;
    }

    public void setTrustStorePass(String trustStorePass) {
        this.trustStorePass = trustStorePass;
    }

    public SSLConfig getSslConfig() {
        if (this.scheme == null || !this.scheme.equalsIgnoreCase("https")) {
            return null;
        }
        return Util.getSSLConfigForSender(this.certPass, this.keyStorePass, this.keyStoreFile, this.trustStoreFile, this.trustStorePass, this.parameters);
    }

    public int getSocketIdleTimeout(int defaultValue) {
        if (this.socketIdleTimeout == 0) {
            return defaultValue;
        }
        return this.socketIdleTimeout;
    }

    public void setSocketIdleTimeout(int socketIdleTimeout) {
        this.socketIdleTimeout = socketIdleTimeout;
    }
}

