/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.listener;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wso2.carbon.messaging.ServerConnector;
import org.wso2.carbon.messaging.ServerConnectorProvider;
import org.wso2.carbon.transport.http.netty.config.ConfigurationBuilder;
import org.wso2.carbon.transport.http.netty.config.ListenerConfiguration;
import org.wso2.carbon.transport.http.netty.config.TransportsConfiguration;
import org.wso2.carbon.transport.http.netty.listener.HTTPServerConnector;
import org.wso2.carbon.transport.http.netty.listener.ServerConnectorController;

public class HTTPServerConnectorProvider
extends ServerConnectorProvider {
    private ServerConnectorController serverConnectorController;

    public HTTPServerConnectorProvider() {
        super("http");
    }

    public List<ServerConnector> initializeConnectors(TransportsConfiguration trpConfig) {
        ArrayList<ServerConnector> connectors = new ArrayList<ServerConnector>();
        this.createServerConnectorController(trpConfig);
        Set<ListenerConfiguration> listenerConfigurationSet = trpConfig.getListenerConfigurations();
        listenerConfigurationSet.forEach(config -> {
            HTTPServerConnector connector = new HTTPServerConnector(config.getId());
            connector.setListenerConfiguration((ListenerConfiguration)config);
            connector.setServerConnectorController(this.serverConnectorController);
            if (config.isBindOnStartup()) {
                this.serverConnectorController.bindInterface(connector);
            }
            connectors.add(connector);
        });
        return connectors;
    }

    @Override
    public List<ServerConnector> initializeConnectors() {
        return this.initializeConnectors(ConfigurationBuilder.getInstance().getConfiguration());
    }

    @Override
    public ServerConnector createConnector(String s, Map<String, String> properties) {
        TransportsConfiguration trpConfig = ConfigurationBuilder.getInstance().getConfiguration();
        ListenerConfiguration config = this.buildListenerConfig(s, properties);
        this.createServerConnectorController(trpConfig);
        HTTPServerConnector connector = new HTTPServerConnector(config.getId());
        connector.setListenerConfiguration(config);
        connector.setServerConnectorController(this.serverConnectorController);
        if (config.isBindOnStartup()) {
            this.serverConnectorController.bindInterface(connector);
        }
        return connector;
    }

    private synchronized void createServerConnectorController(TransportsConfiguration trpConfig) {
        if (this.serverConnectorController == null) {
            this.serverConnectorController = new ServerConnectorController(trpConfig);
            this.serverConnectorController.start();
        }
    }

    private ListenerConfiguration buildListenerConfig(String id, Map<String, String> properties) {
        String host = properties.get("host") != null ? properties.get("host") : "0.0.0.0";
        int port = Integer.parseInt(properties.get("port"));
        ListenerConfiguration config = new ListenerConfiguration(id, host, port);
        String schema = properties.get("scheme");
        if (schema != null && schema.equals("https")) {
            config.setScheme(schema);
            config.setKeyStoreFile(properties.get("keyStoreFile"));
            config.setKeyStorePass(properties.get("keyStorePass"));
            config.setCertPass(properties.get("certPass"));
        }
        return config;
    }

    @Override
    public int getCount() {
        return ConfigurationBuilder.getInstance().getConfiguration().getListenerConfigurations().size();
    }
}

