/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.listener;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.DefaultCarbonMessage;
import org.wso2.carbon.transport.http.netty.common.Util;
import org.wso2.carbon.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.carbon.transport.http.netty.listener.RequestDataHolder;
import org.wso2.carbon.transport.http.netty.listener.ResponseContentWriter;
import org.wso2.carbon.transport.http.netty.message.HTTPCarbonMessage;

public class ResponseCallback
implements CarbonCallback {
    private ChannelHandlerContext ctx;
    private static final Logger logger = LoggerFactory.getLogger(ResponseCallback.class);
    private RequestDataHolder requestDataHolder;

    public ResponseCallback(ChannelHandlerContext channelHandlerContext, CarbonMessage requestMsg) {
        this.ctx = channelHandlerContext;
        this.requestDataHolder = new RequestDataHolder(requestMsg);
    }

    @Override
    public void done(CarbonMessage cMsg) {
        block11: {
            boolean connectionCloseAfterResponse;
            block12: {
                connectionCloseAfterResponse = this.shouldConnectionClose(cMsg);
                Util.prepareBuiltMessageForTransfer(cMsg);
                Util.setupTransferEncodingForResponse(cMsg, this.requestDataHolder);
                if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
                    HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceResponseReceiving(cMsg);
                }
                HttpResponse response = Util.createHttpResponse(cMsg, connectionCloseAfterResponse);
                this.ctx.write(response);
                if (cMsg.isBufferContent()) break block12;
                cMsg.setWriter(new ResponseContentWriter(this.ctx));
                break block11;
            }
            if (cMsg instanceof HTTPCarbonMessage) {
                HTTPCarbonMessage nettyCMsg = (HTTPCarbonMessage)cMsg;
                while (true) {
                    if (nettyCMsg.isEndOfMsgAdded() && nettyCMsg.isEmpty()) {
                        ChannelFuture future = this.ctx.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
                        if (!connectionCloseAfterResponse) break block11;
                        future.addListener(ChannelFutureListener.CLOSE);
                        break block11;
                    }
                    HttpContent httpContent = nettyCMsg.getHttpContent();
                    if (httpContent instanceof LastHttpContent) {
                        ChannelFuture future = this.ctx.writeAndFlush(httpContent);
                        if (connectionCloseAfterResponse) {
                            future.addListener(ChannelFutureListener.CLOSE);
                        }
                        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() == null) break block11;
                        HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceResponseSending(cMsg);
                        break block11;
                    }
                    this.ctx.write(httpContent);
                }
            }
            if (!(cMsg instanceof DefaultCarbonMessage)) break block11;
            DefaultCarbonMessage defaultCMsg = (DefaultCarbonMessage)cMsg;
            if (defaultCMsg.isEndOfMsgAdded() && defaultCMsg.isEmpty()) {
                ChannelFuture future = this.ctx.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
                if (connectionCloseAfterResponse) {
                    future.addListener(ChannelFutureListener.CLOSE);
                }
                return;
            }
            do {
                ByteBuffer byteBuffer = defaultCMsg.getMessageBody();
                ByteBuf bbuf = Unpooled.wrappedBuffer(byteBuffer);
                DefaultHttpContent httpContent = new DefaultHttpContent(bbuf);
                this.ctx.write(httpContent);
            } while (!defaultCMsg.isEndOfMsgAdded() || !defaultCMsg.isEmpty());
            ChannelFuture future = this.ctx.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
            if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
                HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceResponseSending(cMsg);
            }
            if (connectionCloseAfterResponse) {
                future.addListener(ChannelFutureListener.CLOSE);
            }
        }
    }

    private boolean shouldConnectionClose(CarbonMessage responseMsg) {
        String responseConnectionHeader = responseMsg.getHeader("Connection");
        String requestConnectionHeader = this.requestDataHolder.getConnectionHeader();
        return responseConnectionHeader != null && "Close".equalsIgnoreCase(responseConnectionHeader) || requestConnectionHeader != null && "Close".equalsIgnoreCase(requestConnectionHeader);
    }
}

