/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.sender.channel.pool;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.exceptions.MessagingException;
import org.wso2.carbon.transport.http.netty.common.HttpRoute;
import org.wso2.carbon.transport.http.netty.common.Util;
import org.wso2.carbon.transport.http.netty.config.SenderConfiguration;
import org.wso2.carbon.transport.http.netty.listener.SourceHandler;
import org.wso2.carbon.transport.http.netty.sender.TargetHandler;
import org.wso2.carbon.transport.http.netty.sender.channel.ChannelUtils;
import org.wso2.carbon.transport.http.netty.sender.channel.TargetChannel;
import org.wso2.carbon.transport.http.netty.sender.channel.pool.PoolConfiguration;
import org.wso2.carbon.transport.http.netty.sender.channel.pool.PoolableTargetChannelFactory;
import org.wso2.carbon.transport.http.netty.sender.channel.pool.PoolableTargetChannelFactoryPerSrcHndlr;

public class ConnectionManager {
    private static final Logger log = LoggerFactory.getLogger(ConnectionManager.class);
    private EventLoopGroup clientEventGroup;
    private PoolConfiguration poolConfiguration;
    private PoolManagementPolicy poolManagementPolicy;
    private final Map<String, GenericObjectPool> connGlobalPool;
    private AtomicInteger index = new AtomicInteger(1);
    private static volatile ConnectionManager connectionManager;

    private ConnectionManager(PoolConfiguration poolConfiguration, Map<String, Object> transportProperties) {
        this.poolConfiguration = poolConfiguration;
        if (poolConfiguration.getNumberOfPools() == 1) {
            this.poolManagementPolicy = PoolManagementPolicy.LOCK_DEFAULT_POOLING;
        }
        this.connGlobalPool = new ConcurrentHashMap<String, GenericObjectPool>();
        this.clientEventGroup = new NioEventLoopGroup(Util.getIntProperty(transportProperties, "client.bootstrap.worker.group.size", 4));
    }

    private GenericObjectPool createPoolForRoute(HttpRoute httpRoute, EventLoopGroup eventLoopGroup, Class eventLoopClass, SenderConfiguration senderConfiguration) {
        GenericObjectPool.Config config = new GenericObjectPool.Config();
        config.maxActive = this.poolConfiguration.getMaxActivePerPool();
        config.maxIdle = this.poolConfiguration.getMaxIdlePerPool();
        config.minIdle = this.poolConfiguration.getMinIdlePerPool();
        config.testOnBorrow = this.poolConfiguration.isTestOnBorrow();
        config.testWhileIdle = this.poolConfiguration.isTestWhileIdle();
        config.timeBetweenEvictionRunsMillis = this.poolConfiguration.getTimeBetweenEvictionRuns();
        config.minEvictableIdleTimeMillis = this.poolConfiguration.getMinEvictableIdleTime();
        config.whenExhaustedAction = this.poolConfiguration.getExhaustedAction();
        config.maxWait = this.poolConfiguration.getMaxWait();
        return new GenericObjectPool((PoolableObjectFactory)new PoolableTargetChannelFactory(httpRoute, eventLoopGroup, eventLoopClass, senderConfiguration), config);
    }

    private GenericObjectPool createPoolForRoutePerSrcHndlr(GenericObjectPool genericObjectPool) {
        GenericObjectPool.Config config = new GenericObjectPool.Config();
        config.maxActive = this.poolConfiguration.getMaxActivePerPool();
        config.maxIdle = this.poolConfiguration.getMaxIdlePerPool();
        config.minIdle = this.poolConfiguration.getMinIdlePerPool();
        config.testOnBorrow = this.poolConfiguration.isTestOnBorrow();
        config.testWhileIdle = this.poolConfiguration.isTestWhileIdle();
        config.timeBetweenEvictionRunsMillis = this.poolConfiguration.getTimeBetweenEvictionRuns();
        config.minEvictableIdleTimeMillis = this.poolConfiguration.getMinEvictableIdleTime();
        config.whenExhaustedAction = this.poolConfiguration.getExhaustedAction();
        return new GenericObjectPool((PoolableObjectFactory)new PoolableTargetChannelFactoryPerSrcHndlr(genericObjectPool), config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConnectionManager getInstance(Map<String, Object> transportProperties) {
        if (connectionManager != null) return connectionManager;
        Class<ConnectionManager> clazz = ConnectionManager.class;
        synchronized (ConnectionManager.class) {
            if (connectionManager != null) return connectionManager;
            PoolConfiguration poolConfiguration = PoolConfiguration.getInstance();
            if (poolConfiguration == null) {
                PoolConfiguration.createPoolConfiguration(transportProperties);
                poolConfiguration = PoolConfiguration.getInstance();
            }
            connectionManager = new ConnectionManager(poolConfiguration, transportProperties);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return connectionManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTargetChannel(HttpRoute httpRoute, SourceHandler sourceHandler, SenderConfiguration senderConfiguration, HttpRequest httpRequest, CarbonMessage carbonMessage, CarbonCallback carbonCallback) throws Exception {
        try {
            GenericObjectPool trgHlrConnPool;
            if (sourceHandler != null) {
                ChannelHandlerContext ctx = sourceHandler.getInboundChannelContext();
                EventLoop group = ctx.channel().eventLoop();
                Class<?> cl = ctx.channel().getClass();
                if (this.poolManagementPolicy == PoolManagementPolicy.LOCK_DEFAULT_POOLING) {
                    Map<String, GenericObjectPool> srcHlrConnPool = sourceHandler.getTargetChannelPool();
                    trgHlrConnPool = srcHlrConnPool.get(httpRoute.toString());
                    if (trgHlrConnPool == null) {
                        trgHlrConnPool = this.createPoolForRoute(httpRoute, group, cl, senderConfiguration);
                        srcHlrConnPool.put(httpRoute.toString(), trgHlrConnPool);
                    }
                } else {
                    Map<String, GenericObjectPool> srcHlrConnPool = sourceHandler.getTargetChannelPool();
                    trgHlrConnPool = srcHlrConnPool.get(httpRoute.toString());
                    if (trgHlrConnPool == null) {
                        ConnectionManager connectionManager = this;
                        synchronized (connectionManager) {
                            if (!this.connGlobalPool.containsKey(httpRoute.toString())) {
                                trgHlrConnPool = this.createPoolForRoute(httpRoute, group, cl, senderConfiguration);
                                this.connGlobalPool.put(httpRoute.toString(), trgHlrConnPool);
                            }
                            trgHlrConnPool = this.connGlobalPool.get(httpRoute.toString());
                            trgHlrConnPool = this.createPoolForRoutePerSrcHndlr(trgHlrConnPool);
                        }
                        srcHlrConnPool.put(httpRoute.toString(), trgHlrConnPool);
                    }
                }
            } else {
                Class<NioSocketChannel> cl = NioSocketChannel.class;
                EventLoopGroup group = this.clientEventGroup;
                ConnectionManager connectionManager = this;
                synchronized (connectionManager) {
                    if (!this.connGlobalPool.containsKey(httpRoute.toString())) {
                        trgHlrConnPool = this.createPoolForRoute(httpRoute, group, cl, senderConfiguration);
                        this.connGlobalPool.put(httpRoute.toString(), trgHlrConnPool);
                    }
                    trgHlrConnPool = this.connGlobalPool.get(httpRoute.toString());
                }
            }
            TargetChannel targetChannel = (TargetChannel)trgHlrConnPool.borrowObject();
            if (targetChannel.getChannel() != null) {
                targetChannel.setTargetHandler(targetChannel.getHTTPClientInitializer().getTargetHandler());
                targetChannel.setCorrelatedSource(sourceHandler);
                targetChannel.setHttpRoute(httpRoute);
                TargetHandler targetHandler = targetChannel.getTargetHandler();
                targetHandler.setCallback(carbonCallback);
                targetHandler.setIncomingMsg(carbonMessage);
                targetHandler.setConnectionManager(connectionManager);
                targetHandler.setTargetChannel(targetChannel);
                int socketIdleTimeout = senderConfiguration.getSocketIdleTimeout(60000);
                targetChannel.getChannel().pipeline().addBefore("targetHandler", "idleStateHandler", new IdleStateHandler(socketIdleTimeout, socketIdleTimeout, 0L, TimeUnit.MILLISECONDS));
                targetChannel.setRequestWritten(true);
                ChannelUtils.writeContent(targetChannel.getChannel(), httpRequest, carbonMessage);
            }
        }
        catch (Exception e) {
            String msg = "Failed to send the request : " + e.getMessage().toLowerCase(Locale.ENGLISH);
            log.error(msg, e);
            MessagingException messagingException = new MessagingException(msg, e, 101500);
            carbonMessage.setMessagingException(messagingException);
            carbonCallback.done(carbonMessage);
        }
    }

    public void returnChannel(TargetChannel targetChannel) throws Exception {
        targetChannel.setRequestWritten(false);
        Map<String, GenericObjectPool> objectPoolMap = targetChannel.getCorrelatedSource().getTargetChannelPool();
        this.releaseChannelToPool(targetChannel, objectPoolMap.get(targetChannel.getHttpRoute().toString()));
    }

    private void releaseChannelToPool(TargetChannel targetChannel, GenericObjectPool pool) throws Exception {
        try {
            if (targetChannel.getChannel().isActive()) {
                pool.returnObject(targetChannel);
            }
        }
        catch (Exception e) {
            throw new Exception("Cannot return channel to pool", e);
        }
    }

    public void invalidateTargetChannel(TargetChannel targetChannel) throws Exception {
        targetChannel.setRequestWritten(false);
        Map<String, GenericObjectPool> objectPoolMap = targetChannel.getCorrelatedSource().getTargetChannelPool();
        try {
            if (objectPoolMap.get(targetChannel.getHttpRoute().toString()) != null) {
                objectPoolMap.get(targetChannel.getHttpRoute().toString()).invalidateObject(targetChannel);
            }
        }
        catch (Exception e) {
            throw new Exception("Cannot invalidate channel from pool", e);
        }
    }

    public Map<String, GenericObjectPool> getTargetChannelPool() {
        return this.connGlobalPool;
    }

    public void notifyChannelInactive() {
        if (this.poolManagementPolicy == PoolManagementPolicy.GLOBAL_ENDPOINT_CONNECTION_CACHING) {
            this.index.getAndDecrement();
        }
    }

    public PoolConfiguration getPoolConfiguration() {
        return this.poolConfiguration;
    }

    public static enum PoolManagementPolicy {
        GLOBAL_ENDPOINT_CONNECTION_CACHING,
        LOCK_DEFAULT_POOLING;

    }
}

