/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.spring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.wso2.carbon.transport.http.netty.config.ListenerConfiguration;
import org.wso2.carbon.transport.http.netty.config.Parameter;
import org.wso2.carbon.transport.http.netty.config.TransportProperty;
import org.wso2.carbon.transport.http.netty.config.TransportsConfiguration;
import org.wso2.carbon.transport.http.netty.listener.HTTPServerConnectorProvider;
import org.wso2.carbon.transport.http.netty.listener.ServerConnectorController;
import org.wso2.msf4j.MicroservicesRunner;
import org.wso2.msf4j.interceptor.RequestInterceptor;
import org.wso2.msf4j.interceptor.ResponseInterceptor;
import org.wso2.msf4j.internal.DataHolder;
import org.wso2.msf4j.internal.MSF4JMessageProcessor;
import org.wso2.msf4j.spring.transport.HTTPSTransportConfig;
import org.wso2.msf4j.spring.transport.TransportConfig;

@Component
public class SpringMicroservicesRunner
extends MicroservicesRunner
implements ApplicationContextAware,
InitializingBean {
    private final Log log = LogFactory.getLog(this.getClass());
    @Autowired
    private ApplicationContext applicationContext;

    public SpringMicroservicesRunner() {
    }

    public SpringMicroservicesRunner(int ... ports) {
        super(ports);
    }

    public void init() {
        for (Map.Entry<String, Object> entry : this.applicationContext.getBeansWithAnnotation(Path.class).entrySet()) {
            this.log.info("Deploying " + entry.getKey() + " bean as a resource");
            this.deploy(entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.applicationContext.getBeansOfType(RequestInterceptor.class).entrySet()) {
            this.log.info("Adding " + entry.getKey() + "  RequestInterceptor");
            this.addGlobalRequestInterceptor((RequestInterceptor)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.applicationContext.getBeansOfType(ResponseInterceptor.class).entrySet()) {
            this.log.info("Adding " + entry.getKey() + "  ResponseInterceptor");
            this.addGlobalResponseInterceptor((ResponseInterceptor)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.applicationContext.getBeansOfType(ExceptionMapper.class).entrySet()) {
            this.log.info("Adding " + entry.getKey() + "  ExceptionMapper");
            this.addExceptionMapper((ExceptionMapper)entry.getValue());
        }
        this.configureTransport(this.applicationContext.getBeansOfType(ListenerConfiguration.class).values(), this.applicationContext.getBeansOfType(TransportConfig.class).values());
        this.start();
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    @Override
    protected void configureTransport() {
    }

    protected void configureTransport(Collection<ListenerConfiguration> listeners, Collection<TransportConfig> transportConfigs) {
        if (System.getProperty("transports.netty.conf") != null) {
            super.configureTransport();
            return;
        }
        HashSet<TransportProperty> transportProperties = new HashSet<TransportProperty>();
        TransportProperty transportProperty = new TransportProperty();
        int bossGroupSize = Runtime.getRuntime().availableProcessors();
        transportProperty.setName("server.bootstrap.boss.group.size");
        transportProperty.setValue(bossGroupSize);
        TransportProperty workerGroup = new TransportProperty();
        int workerGroupSize = Runtime.getRuntime().availableProcessors() * 2;
        workerGroup.setName("server.bootstrap.worker.group.size");
        workerGroup.setValue(workerGroupSize);
        transportProperties.add(transportProperty);
        transportProperties.add(workerGroup);
        TransportsConfiguration transportsConfiguration = new TransportsConfiguration();
        ServerConnectorController serverConnectorController = new ServerConnectorController(transportsConfiguration);
        serverConnectorController.start();
        HTTPServerConnectorProvider httpServerConnectorProvider = new HTTPServerConnectorProvider();
        transportsConfiguration.setTransportProperties(transportProperties);
        HashSet<ListenerConfiguration> listenerConfigurations = new HashSet<ListenerConfiguration>();
        listeners.forEach(listenerConfiguration -> {
            listenerConfigurations.add((ListenerConfiguration)listenerConfiguration);
            DataHolder.getInstance().getMicroservicesRegistries().put(listenerConfiguration.getId(), this.getMsRegistry());
        });
        for (TransportConfig transportConfig : transportConfigs) {
            if (!transportConfig.isEnabled()) continue;
            ListenerConfiguration listenerConfiguration2 = this.createListenerConfiguration(transportConfig);
            listenerConfigurations.add(listenerConfiguration2);
            DataHolder.getInstance().getMicroservicesRegistries().put(transportConfig.getId(), this.getMsRegistry());
        }
        transportsConfiguration.setListenerConfigurations(listenerConfigurations);
        this.serverConnectors = httpServerConnectorProvider.initializeConnectors(transportsConfiguration);
        this.serverConnectors.forEach(serverConnector -> serverConnector.setMessageProcessor(new MSF4JMessageProcessor()));
    }

    private ListenerConfiguration createListenerConfiguration(TransportConfig transportConfig) {
        ListenerConfiguration listenerConfig = new ListenerConfiguration(transportConfig.getId(), transportConfig.getHost(), transportConfig.getPort());
        listenerConfig.setScheme(transportConfig.getScheme());
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (Map.Entry<String, String> entry : transportConfig.getParameters().entrySet()) {
            parameters.add(this.createParameter(entry.getKey(), entry.getValue()));
        }
        listenerConfig.setParameters(parameters);
        if ("https".equals(transportConfig.getScheme())) {
            HTTPSTransportConfig httpsTransportConfig = (HTTPSTransportConfig)transportConfig;
            listenerConfig.setKeyStoreFile(httpsTransportConfig.getKeyStoreFile());
            listenerConfig.setKeyStorePass(httpsTransportConfig.getKeyStorePass());
            listenerConfig.setCertPass(httpsTransportConfig.getCertPass());
        }
        return listenerConfig;
    }

    private Parameter createParameter(String key, String value) {
        Parameter parameter = new Parameter();
        parameter.setName(key);
        parameter.setValue(value);
        return parameter;
    }
}

