/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.jcache;

import java.util.Collection;
import java.util.LinkedHashSet;
import javax.cache.CacheManager;
import javax.cache.Caching;
import org.springframework.cache.Cache;
import org.springframework.cache.jcache.JCacheCache;
import org.springframework.cache.transaction.AbstractTransactionSupportingCacheManager;

public class JCacheCacheManager
extends AbstractTransactionSupportingCacheManager {
    private CacheManager cacheManager;
    private boolean allowNullValues = true;

    public JCacheCacheManager() {
    }

    public JCacheCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setAllowNullValues(boolean allowNullValues) {
        this.allowNullValues = allowNullValues;
    }

    public boolean isAllowNullValues() {
        return this.allowNullValues;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.getCacheManager() == null) {
            this.setCacheManager(Caching.getCachingProvider().getCacheManager());
        }
        super.afterPropertiesSet();
    }

    protected Collection<Cache> loadCaches() {
        LinkedHashSet<Cache> caches = new LinkedHashSet<Cache>();
        for (String cacheName : this.getCacheManager().getCacheNames()) {
            javax.cache.Cache jcache = this.getCacheManager().getCache(cacheName);
            caches.add(new JCacheCache((javax.cache.Cache<Object, Object>)jcache, this.isAllowNullValues()));
        }
        return caches;
    }

    @Override
    protected Cache getMissingCache(String name) {
        javax.cache.Cache jcache = this.getCacheManager().getCache(name);
        if (jcache != null) {
            return new JCacheCache((javax.cache.Cache<Object, Object>)jcache, this.isAllowNullValues());
        }
        return null;
    }
}

