/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http;

import java.util.concurrent.TimeUnit;
import org.springframework.util.StringUtils;

public class CacheControl {
    private long maxAge = -1L;
    private boolean noCache = false;
    private boolean noStore = false;
    private boolean mustRevalidate = false;
    private boolean noTransform = false;
    private boolean cachePublic = false;
    private boolean cachePrivate = false;
    private boolean proxyRevalidate = false;
    private long sMaxAge = -1L;

    protected CacheControl() {
    }

    public static CacheControl empty() {
        return new CacheControl();
    }

    public static CacheControl maxAge(long maxAge, TimeUnit unit) {
        CacheControl cc = new CacheControl();
        cc.maxAge = unit.toSeconds(maxAge);
        return cc;
    }

    public static CacheControl noCache() {
        CacheControl cc = new CacheControl();
        cc.noCache = true;
        return cc;
    }

    public static CacheControl noStore() {
        CacheControl cc = new CacheControl();
        cc.noStore = true;
        return cc;
    }

    public CacheControl mustRevalidate() {
        this.mustRevalidate = true;
        return this;
    }

    public CacheControl noTransform() {
        this.noTransform = true;
        return this;
    }

    public CacheControl cachePublic() {
        this.cachePublic = true;
        return this;
    }

    public CacheControl cachePrivate() {
        this.cachePrivate = true;
        return this;
    }

    public CacheControl proxyRevalidate() {
        this.proxyRevalidate = true;
        return this;
    }

    public CacheControl sMaxAge(long sMaxAge, TimeUnit unit) {
        this.sMaxAge = unit.toSeconds(sMaxAge);
        return this;
    }

    public String getHeaderValue() {
        String ccHeaderValue;
        StringBuilder ccValue = new StringBuilder();
        if (this.maxAge != -1L) {
            this.appendDirective(ccValue, "max-age=" + Long.toString(this.maxAge));
        }
        if (this.noCache) {
            this.appendDirective(ccValue, "no-cache");
        }
        if (this.noStore) {
            this.appendDirective(ccValue, "no-store");
        }
        if (this.mustRevalidate) {
            this.appendDirective(ccValue, "must-revalidate");
        }
        if (this.noTransform) {
            this.appendDirective(ccValue, "no-transform");
        }
        if (this.cachePublic) {
            this.appendDirective(ccValue, "public");
        }
        if (this.cachePrivate) {
            this.appendDirective(ccValue, "private");
        }
        if (this.proxyRevalidate) {
            this.appendDirective(ccValue, "proxy-revalidate");
        }
        if (this.sMaxAge != -1L) {
            this.appendDirective(ccValue, "s-maxage=" + Long.toString(this.sMaxAge));
        }
        return StringUtils.hasText(ccHeaderValue = ccValue.toString()) ? ccHeaderValue : null;
    }

    private void appendDirective(StringBuilder builder, String value) {
        if (builder.length() > 0) {
            builder.append(", ");
        }
        builder.append(value);
    }
}

