/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.listener;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import java.nio.ByteBuffer;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.Writer;
import org.wso2.carbon.transport.http.netty.internal.HTTPTransportContextHolder;

public class ResponseContentWriter
implements Writer {
    private ChannelHandlerContext channelHandlerContext;
    private static final String HTTP_CONNECTION_CLOSE = "close";

    public ResponseContentWriter(ChannelHandlerContext channelHandlerContext) {
        this.channelHandlerContext = channelHandlerContext;
    }

    @Override
    public void write(ByteBuffer byteBuffer) {
        ByteBuf bbuf = Unpooled.copiedBuffer(byteBuffer);
        DefaultHttpContent httpContent = new DefaultHttpContent(bbuf);
        this.channelHandlerContext.write(httpContent);
    }

    @Override
    public void writeLastContent(CarbonMessage carbonMessage) {
        String connection;
        ChannelFuture future = this.channelHandlerContext.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceResponseSending(carbonMessage);
        }
        if ((connection = carbonMessage.getHeader("Connection")) != null && HTTP_CONNECTION_CLOSE.equalsIgnoreCase(connection)) {
            future.addListener(ChannelFutureListener.CLOSE);
        }
    }
}

