/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.sender.websocket;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.CharsetUtil;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.BinaryCarbonMessage;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.carbon.messaging.ControlCarbonMessage;
import org.wso2.carbon.messaging.StatusCarbonMessage;
import org.wso2.carbon.messaging.TextCarbonMessage;
import org.wso2.carbon.transport.http.netty.exception.UnknownWebSocketFrameTypeException;
import org.wso2.carbon.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.carbon.transport.http.netty.internal.websocket.Util;
import org.wso2.carbon.transport.http.netty.internal.websocket.WebSocketSessionImpl;
import org.wso2.carbon.transport.http.netty.listener.WebSocketSourceHandler;
import org.wso2.carbon.transport.http.netty.sender.websocket.WebSocketClient;

public class WebSocketTargetHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger log = LoggerFactory.getLogger(WebSocketClient.class);
    private final WebSocketClientHandshaker handshaker;
    private final boolean isSecure;
    private final String requestedUri;
    private final WebSocketSourceHandler sourceHandler;
    private final CarbonMessageProcessor carbonMessageProcessor;
    private final String clientServiceName;
    private WebSocketSessionImpl clientSession;
    private ChannelPromise handshakeFuture;
    private CarbonMessage cMsg;

    public WebSocketTargetHandler(WebSocketClientHandshaker handshaker, WebSocketSourceHandler sourceHandler, boolean isSecure, String requestedUri, String clientServiceName, CarbonMessageProcessor messageProcessor) {
        this.handshaker = handshaker;
        this.sourceHandler = sourceHandler;
        this.isSecure = isSecure;
        this.requestedUri = requestedUri;
        this.clientServiceName = clientServiceName;
        this.carbonMessageProcessor = messageProcessor;
        this.cMsg = null;
        this.handshakeFuture = null;
    }

    public ChannelFuture handshakeFuture() {
        return this.handshakeFuture;
    }

    public Session getClientSession() {
        return this.clientSession;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        this.handshakeFuture = ctx.newPromise();
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws URISyntaxException {
        this.handshaker.handshake(ctx.channel());
        this.clientSession = Util.getSession(ctx, this.isSecure, this.requestedUri);
        if (this.sourceHandler != null) {
            this.sourceHandler.addClientSession(this.clientSession);
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        log.debug("WebSocket Client disconnected!");
        this.cMsg = new StatusCarbonMessage("STATUS_CLOSE", 1001, "Server is going away");
        this.setupCarbonMessage(ctx);
        this.publishToMessageProcessor(this.cMsg, ctx);
    }

    @Override
    public void channelRead0(ChannelHandlerContext ctx, Object msg) throws UnknownWebSocketFrameTypeException, URISyntaxException {
        Channel ch = ctx.channel();
        if (!this.handshaker.isHandshakeComplete()) {
            this.handshaker.finishHandshake(ch, (FullHttpResponse)msg);
            log.debug("WebSocket Client connected!");
            this.handshakeFuture.setSuccess();
            this.clientSession = Util.getSession(ctx, this.isSecure, this.requestedUri);
            if (this.sourceHandler != null) {
                this.sourceHandler.addClientSession(this.clientSession);
            }
            return;
        }
        if (msg instanceof FullHttpResponse) {
            FullHttpResponse response = (FullHttpResponse)msg;
            throw new IllegalStateException("Unexpected FullHttpResponse (getStatus=" + response.status() + ", content=" + response.content().toString(CharsetUtil.UTF_8) + ')');
        }
        WebSocketFrame frame = (WebSocketFrame)msg;
        if (frame instanceof TextWebSocketFrame) {
            TextWebSocketFrame textFrame = (TextWebSocketFrame)frame;
            this.cMsg = new TextCarbonMessage(textFrame.text());
        } else if (frame instanceof BinaryWebSocketFrame) {
            BinaryWebSocketFrame binaryFrame = (BinaryWebSocketFrame)frame;
            this.cMsg = new BinaryCarbonMessage(binaryFrame.content().nioBuffer(), binaryFrame.isFinalFragment());
        } else if (frame instanceof PongWebSocketFrame) {
            PongWebSocketFrame pongFrame = (PongWebSocketFrame)frame;
            this.cMsg = new ControlCarbonMessage("CONTROL_SIGNAL_HEARTBEAT", pongFrame.content().nioBuffer(), true);
        } else if (frame instanceof PingWebSocketFrame) {
            PingWebSocketFrame pingFrame = (PingWebSocketFrame)frame;
            ctx.channel().writeAndFlush(new PongWebSocketFrame(pingFrame.content()));
        } else if (frame instanceof CloseWebSocketFrame) {
            CloseWebSocketFrame closeFrame = (CloseWebSocketFrame)frame;
            this.cMsg = new StatusCarbonMessage("STATUS_CLOSE", closeFrame.statusCode(), closeFrame.reasonText());
            ch.close();
        } else {
            throw new UnknownWebSocketFrameTypeException("Cannot identify the WebSocket frame type");
        }
        this.setupCarbonMessage(ctx);
        this.publishToMessageProcessor(this.cMsg, ctx);
    }

    protected void publishToMessageProcessor(CarbonMessage cMsg, ChannelHandlerContext ctx) {
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceRequestReceiving(cMsg);
        }
        if (this.carbonMessageProcessor != null) {
            try {
                this.carbonMessageProcessor.receive(cMsg, null);
            }
            catch (Exception e) {
                log.error("Error while submitting CarbonMessage to CarbonMessageProcessor.", e);
                ctx.channel().close();
            }
        } else {
            log.error("Cannot find registered MessageProcessor to forward the message.");
            ctx.channel().close();
        }
    }

    private void setupCarbonMessage(ChannelHandlerContext ctx) {
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceRequestReceiving(this.cMsg);
        }
        this.cMsg.setProperty("PORT", ((InetSocketAddress)ctx.channel().remoteAddress()).getPort());
        this.cMsg.setProperty("HOST", ((InetSocketAddress)ctx.channel().remoteAddress()).getHostName());
        this.cMsg.setProperty("LISTENER_PORT", ((InetSocketAddress)ctx.channel().localAddress()).getPort());
        this.cMsg.setProperty("LOCAL_ADDRESS", ctx.channel().localAddress());
        this.cMsg.setProperty("LOCAL_NAME", ((InetSocketAddress)ctx.channel().localAddress()).getHostName());
        this.cMsg.setProperty("REMOTE_ADDRESS", this.requestedUri);
        this.cMsg.setProperty("REMOTE_HOST", ((InetSocketAddress)ctx.channel().remoteAddress()).getHostName());
        this.cMsg.setProperty("REMOTE_PORT", ((InetSocketAddress)ctx.channel().remoteAddress()).getPort());
        this.cMsg.setProperty("TO", this.clientServiceName);
        this.cMsg.setProperty("PROTOCOL", "ws");
        this.cMsg.setProperty("IS_WEBSOCKET_SERVER", false);
        if (this.sourceHandler != null) {
            this.cMsg.setProperty("WEBSOCKET_SERVER_SESSION", this.sourceHandler.getServerSession());
        }
        this.cMsg.setProperty("WEBSOCKET_CLIENT_SESSION", this.clientSession);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!this.handshakeFuture.isDone()) {
            log.error("Handshake failed : " + cause.getMessage(), cause);
            this.handshakeFuture.setFailure(cause);
        }
        ctx.close();
    }
}

