/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.spring.transport;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public abstract class TransportConfig
implements BeanNameAware {
    private String id;
    private String enabledProperty;
    private String portProperty;
    private String hostProperty;
    private String schemeProperty;
    private String keyStoreFileProperty;
    private String keyStorePassProperty;
    private String certPassProperty;
    private String bossThreadPoolSizeProperty;
    private String workerThreadPoolSizeProperty;
    private String execHandlerThreadPoolSizeProperty;
    private Boolean enabled;
    private Integer port;
    private String host;
    private String scheme;
    private String keyStoreFile;
    private String keyStorePass;
    private String certPass;
    private Integer bossThreadPoolSize;
    private Integer workerThreadPoolSize;
    private Integer execHandlerThreadPoolSize;
    private String beanName;
    private Map<String, String> parameters = new HashMap<String, String>();
    @Autowired
    Environment env;

    @PostConstruct
    public void init() {
        this.id = this.resolveId();
        this.enabled = this.resolveEnabled();
        this.port = this.resolvePort();
        this.host = this.resolveHost();
        if (this.isHTTPS()) {
            this.keyStoreFile = this.resolveKeyStoreFile();
            this.keyStorePass = this.resolveKeyStorePass();
            this.certPass = this.resolveKeyCertPass();
        }
        for (PropertySource<?> propertySource : ((AbstractEnvironment)this.env).getPropertySources()) {
            if (!(propertySource instanceof MapPropertySource) || !"applicationProperties".equals(((MapPropertySource)propertySource).getName())) continue;
            MapPropertySource mapPropertySource = (MapPropertySource)propertySource;
            for (Map.Entry entry : ((Map)mapPropertySource.getSource()).entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith(this.getScheme()) || !key.contains(".parameter.")) continue;
                this.parameters.put(key.substring(key.indexOf(".parameter.") + 11), (String)entry.getValue());
            }
        }
    }

    @Override
    public void setBeanName(String name) {
        this.beanName = name;
    }

    private String resolveKeyCertPass() {
        if (!this.keyStorePassProperty.isEmpty()) {
            return this.keyStorePassProperty;
        }
        return this.keyStorePass;
    }

    private String resolveKeyStorePass() {
        if (!this.keyStorePassProperty.isEmpty()) {
            return this.keyStorePassProperty;
        }
        return this.keyStorePass;
    }

    private String resolveKeyStoreFile() {
        if (!this.keyStoreFileProperty.isEmpty()) {
            return this.keyStoreFileProperty;
        }
        return this.keyStoreFile;
    }

    private String resolveId() {
        return this.id.isEmpty() ? this.beanName : this.id;
    }

    private String resolveHost() {
        if (!this.hostProperty.isEmpty()) {
            return this.hostProperty;
        }
        if (this.host == null) {
            return "0.0.0.0";
        }
        return this.host;
    }

    private int resolvePort() {
        if (!this.portProperty.isEmpty()) {
            return Integer.parseInt(this.portProperty);
        }
        if (this.port == null) {
            return this.isHTTPS() ? 8443 : 8080;
        }
        return this.port;
    }

    private boolean resolveEnabled() {
        if (!this.enabledProperty.isEmpty()) {
            return Boolean.valueOf(this.enabledProperty);
        }
        if (this.enabled == null) {
            return !this.isHTTPS();
        }
        return this.enabled;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getEnabledProperty() {
        return this.enabledProperty;
    }

    public void setEnabledProperty(String enabledProperty) {
        this.enabledProperty = enabledProperty;
    }

    public String getPortProperty() {
        return this.portProperty;
    }

    public void setPortProperty(String portProperty) {
        this.portProperty = portProperty;
    }

    public String getHostProperty() {
        return this.hostProperty;
    }

    public void setHostProperty(String hostProperty) {
        this.hostProperty = hostProperty;
    }

    public String getSchemeProperty() {
        return this.schemeProperty;
    }

    public void setSchemeProperty(String schemeProperty) {
        this.schemeProperty = schemeProperty;
    }

    public String getKeyStoreFileProperty() {
        return this.keyStoreFileProperty;
    }

    public void setKeyStoreFileProperty(String keyStoreFileProperty) {
        this.keyStoreFileProperty = keyStoreFileProperty;
    }

    public String getKeyStorePassProperty() {
        return this.keyStorePassProperty;
    }

    public void setKeyStorePassProperty(String keyStorePassProperty) {
        this.keyStorePassProperty = keyStorePassProperty;
    }

    public String getCertPassProperty() {
        return this.certPassProperty;
    }

    public void setCertPassProperty(String certPassProperty) {
        this.certPassProperty = certPassProperty;
    }

    public String getBossThreadPoolSizeProperty() {
        return this.bossThreadPoolSizeProperty;
    }

    public void setBossThreadPoolSizeProperty(String bossThreadPoolSizeProperty) {
        this.bossThreadPoolSizeProperty = bossThreadPoolSizeProperty;
    }

    public String getWorkerThreadPoolSizeProperty() {
        return this.workerThreadPoolSizeProperty;
    }

    public void setWorkerThreadPoolSizeProperty(String workerThreadPoolSizeProperty) {
        this.workerThreadPoolSizeProperty = workerThreadPoolSizeProperty;
    }

    public String getExecHandlerThreadPoolSizeProperty() {
        return this.execHandlerThreadPoolSizeProperty;
    }

    public void setExecHandlerThreadPoolSizeProperty(String execHandlerThreadPoolSizeProperty) {
        this.execHandlerThreadPoolSizeProperty = execHandlerThreadPoolSizeProperty;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public String getKeyStorePass() {
        return this.keyStorePass;
    }

    public void setKeyStorePass(String keyStorePass) {
        this.keyStorePass = keyStorePass;
    }

    public String getCertPass() {
        return this.certPass;
    }

    public void setCertPass(String certPass) {
        this.certPass = certPass;
    }

    public int getBossThreadPoolSize() {
        return this.bossThreadPoolSize;
    }

    public void setBossThreadPoolSize(int bossThreadPoolSize) {
        this.bossThreadPoolSize = bossThreadPoolSize;
    }

    public int getWorkerThreadPoolSize() {
        return this.workerThreadPoolSize;
    }

    public void setWorkerThreadPoolSize(int workerThreadPoolSize) {
        this.workerThreadPoolSize = workerThreadPoolSize;
    }

    public int getExecHandlerThreadPoolSize() {
        return this.execHandlerThreadPoolSize;
    }

    public void setExecHandlerThreadPoolSize(int execHandlerThreadPoolSize) {
        this.execHandlerThreadPoolSize = execHandlerThreadPoolSize;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public boolean getDefaultEnabled() {
        return !this.isHTTPS();
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean isHTTPS() {
        return "https".equals(this.getScheme());
    }
}

