/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.config;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.wso2.transport.http.netty.common.ProxyServerConfiguration;
import org.wso2.transport.http.netty.common.Util;
import org.wso2.transport.http.netty.common.ssl.SSLConfig;
import org.wso2.transport.http.netty.config.Parameter;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class SenderConfiguration {
    public static final String DEFAULT_KEY = "netty";
    @XmlAttribute(required=true)
    private String id;
    @XmlAttribute
    private String scheme = "http";
    @XmlAttribute
    private String keyStoreFile;
    @XmlAttribute
    private String keyStorePassword;
    @XmlAttribute
    private String trustStoreFile;
    @XmlAttribute
    private String trustStorePass;
    @XmlAttribute
    private String certPass;
    @XmlAttribute
    private int socketIdleTimeout;
    @XmlAttribute
    private boolean httpTraceLogEnabled;
    @XmlAttribute
    private boolean chunkDisabled;
    @XmlAttribute
    private String sslProtocol;
    @XmlElementWrapper(name="parameters")
    @XmlElement(name="parameter")
    private List<Parameter> parameters;
    @XmlAttribute
    private boolean followRedirect;
    @XmlAttribute
    private int maxRedirectCount;
    @XmlAttribute
    private boolean isKeepAlive = true;
    private String tlsStoreType;
    private ProxyServerConfiguration proxyServerConfiguration;

    public static SenderConfiguration getDefault() {
        SenderConfiguration defaultConfig = new SenderConfiguration(DEFAULT_KEY);
        return defaultConfig;
    }

    public SenderConfiguration() {
    }

    public SenderConfiguration(String id) {
        this.id = id;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public String getCertPass() {
        return this.certPass;
    }

    public String getTlsStoreType() {
        return this.tlsStoreType;
    }

    public void setTlsStoreType(String storeType) {
        this.tlsStoreType = storeType;
    }

    public void setCertPass(String certPass) {
        this.certPass = certPass;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public String getTrustStoreFile() {
        return this.trustStoreFile;
    }

    public void setTrustStoreFile(String trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
    }

    public String getTrustStorePass() {
        return this.trustStorePass;
    }

    public void setTrustStorePass(String trustStorePass) {
        this.trustStorePass = trustStorePass;
    }

    public SSLConfig getSslConfig() {
        if (this.scheme == null || !this.scheme.equalsIgnoreCase("https")) {
            return null;
        }
        return Util.getSSLConfigForSender(this.certPass, this.keyStorePassword, this.keyStoreFile, this.trustStoreFile, this.trustStorePass, this.parameters, this.sslProtocol, this.tlsStoreType);
    }

    public int getSocketIdleTimeout(int defaultValue) {
        if (this.socketIdleTimeout == 0) {
            return defaultValue;
        }
        return this.socketIdleTimeout;
    }

    public void setSocketIdleTimeout(int socketIdleTimeout) {
        this.socketIdleTimeout = socketIdleTimeout;
    }

    public boolean isHttpTraceLogEnabled() {
        return this.httpTraceLogEnabled;
    }

    public void setHttpTraceLogEnabled(boolean httpTraceLogEnabled) {
        this.httpTraceLogEnabled = httpTraceLogEnabled;
    }

    public boolean isChunkDisabled() {
        return this.chunkDisabled;
    }

    public void setChunkDisabled(boolean chunkDisabled) {
        this.chunkDisabled = chunkDisabled;
    }

    public boolean isFollowRedirect() {
        return this.followRedirect;
    }

    public void setFollowRedirect(boolean followRedirect) {
        this.followRedirect = followRedirect;
    }

    public int getMaxRedirectCount(int defaultValue) {
        if (this.maxRedirectCount == 0) {
            return defaultValue;
        }
        return this.maxRedirectCount;
    }

    public void setMaxRedirectCount(int maxRedirectCount) {
        this.maxRedirectCount = maxRedirectCount;
    }

    public boolean isKeepAlive() {
        return this.isKeepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.isKeepAlive = keepAlive;
    }

    public void setProxyServerConfiguration(ProxyServerConfiguration proxyServerConfiguration) {
        this.proxyServerConfiguration = proxyServerConfiguration;
    }

    public ProxyServerConfiguration getProxyServerConfiguration() {
        return this.proxyServerConfiguration;
    }
}

