/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.config;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.wso2.transport.http.netty.common.Util;
import org.wso2.transport.http.netty.common.ssl.SSLConfig;
import org.wso2.transport.http.netty.config.Parameter;
import org.wso2.transport.http.netty.config.RequestSizeValidationConfiguration;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class ListenerConfiguration {
    public static final String DEFAULT_KEY = "default";
    @XmlAttribute(required=true)
    private String id = "default";
    @XmlAttribute
    private String host = "0.0.0.0";
    @XmlAttribute(required=true)
    private int port = 8080;
    @XmlAttribute
    private boolean bindOnStartup = false;
    @XmlAttribute
    private String scheme = "http";
    @XmlAttribute
    private boolean http2 = false;
    @XmlAttribute
    private String keyStoreFile;
    @XmlAttribute
    private String keyStorePassword;
    @XmlAttribute
    private String trustStoreFile;
    @XmlAttribute
    private String trustStorePass;
    @XmlAttribute
    private String certPass;
    @XmlAttribute
    private int socketIdleTimeout;
    @XmlAttribute
    private String messageProcessorId;
    @XmlAttribute
    private boolean httpTraceLogEnabled;
    @XmlAttribute
    private String verifyClient;
    @XmlAttribute
    private String sslProtocol;
    @XmlAttribute
    private String tlsStoreType;
    @XmlAttribute
    private boolean keepAlive = true;
    @XmlElementWrapper(name="parameters")
    @XmlElement(name="parameter")
    private List<Parameter> parameters = this.getDefaultParameters();
    private RequestSizeValidationConfiguration requestSizeValidationConfig = new RequestSizeValidationConfiguration();

    @Deprecated
    public static ListenerConfiguration getDefault() {
        ListenerConfiguration defaultConfig = new ListenerConfiguration(DEFAULT_KEY, "0.0.0.0", 8080);
        return defaultConfig;
    }

    public ListenerConfiguration() {
    }

    public ListenerConfiguration(String id, String host, int port) {
        this.id = id;
        this.host = host;
        this.port = port;
    }

    public String getTlsStoreType() {
        return this.tlsStoreType;
    }

    public void setTlsStoreType(String tlsStoreType) {
        this.tlsStoreType = tlsStoreType;
    }

    public String getCertPass() {
        return this.certPass;
    }

    public void setCertPass(String certPass) {
        this.certPass = certPass;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setTrustStoreFile(String trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
    }

    public String getTrustStoreFile() {
        return this.trustStoreFile;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public String getKeyStorePass() {
        return this.keyStorePassword;
    }

    public String getTrustStorePass() {
        return this.trustStorePass;
    }

    public void setTrustStorePass(String trustStorePass) {
        this.trustStorePass = trustStorePass;
    }

    public void setKeyStorePass(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public void setVerifyClient(String verifyClient) {
        this.verifyClient = verifyClient;
    }

    public String getVerifyClient() {
        return this.verifyClient;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isBindOnStartup() {
        return this.bindOnStartup;
    }

    public void setBindOnStartup(boolean bindOnStartup) {
        this.bindOnStartup = bindOnStartup;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public boolean isHttp2() {
        return this.http2;
    }

    public void setHttp2(boolean http2) {
        this.http2 = http2;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public SSLConfig getSslConfig() {
        if (this.scheme == null || !this.scheme.equalsIgnoreCase("https")) {
            return null;
        }
        return Util.getSSLConfigForListener(this.certPass, this.keyStorePassword, this.keyStoreFile, this.trustStoreFile, this.trustStorePass, this.parameters, this.verifyClient, this.sslProtocol, this.tlsStoreType);
    }

    private List<Parameter> getDefaultParameters() {
        ArrayList<Parameter> defaultParams = new ArrayList<Parameter>();
        return defaultParams;
    }

    public int getSocketIdleTimeout(int defaultVal) {
        if (this.socketIdleTimeout == 0) {
            return defaultVal;
        }
        return this.socketIdleTimeout;
    }

    public String getMessageProcessorId() {
        return this.messageProcessorId;
    }

    public void setMessageProcessorId(String messageProcessorId) {
        this.messageProcessorId = messageProcessorId;
    }

    public void setSocketIdleTimeout(int socketIdleTimeout) {
        this.socketIdleTimeout = socketIdleTimeout;
    }

    public boolean isHttpTraceLogEnabled() {
        return this.httpTraceLogEnabled;
    }

    public void setHttpTraceLogEnabled(boolean httpTraceLogEnabled) {
        this.httpTraceLogEnabled = httpTraceLogEnabled;
    }

    public RequestSizeValidationConfiguration getRequestSizeValidationConfig() {
        return this.requestSizeValidationConfig;
    }

    public void setRequestSizeValidationConfig(RequestSizeValidationConfiguration requestSizeValidationConfig) {
        this.requestSizeValidationConfig = requestSizeValidationConfig;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }
}

