/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.wso2.msf4j.Request;
import org.wso2.msf4j.Session;
import org.wso2.msf4j.delegates.CookieHeaderProvider;
import org.wso2.msf4j.internal.HttpHeadersImpl;
import org.wso2.msf4j.internal.entitywriter.EntityWriter;
import org.wso2.msf4j.internal.entitywriter.EntityWriterRegistry;
import org.wso2.transport.http.netty.contract.ServerConnectorException;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

public class Response {
    private static final String COMMA_SEPARATOR = ", ";
    private static final int NULL_STATUS_CODE = -1;
    public static final int NO_CHUNK = 0;
    public static final int DEFAULT_CHUNK_SIZE = -1;
    private final HTTPCarbonMessage httpCarbonMessage;
    private int statusCode = -1;
    private String mediaType = null;
    private Object entity;
    private int chunkSize = 0;
    private Request request;
    private javax.ws.rs.core.Response jaxrsResponse;

    public Response(HTTPCarbonMessage responder) {
        this.httpCarbonMessage = responder;
    }

    public Response(Request request) {
        this(request.getHttpCarbonMessage().cloneCarbonMessageWithOutData());
        this.request = request;
    }

    @Deprecated
    public boolean isEomAdded() {
        return this.httpCarbonMessage.isEndOfMsgAdded();
    }

    public boolean isEmpty() {
        return this.httpCarbonMessage.isEmpty();
    }

    @Deprecated
    public ByteBuf getMessageBody() {
        return this.httpCarbonMessage.getMessageBody();
    }

    @Deprecated
    public List<ByteBuffer> getFullMessageBody() {
        return this.httpCarbonMessage.getFullMessageBody();
    }

    public HttpHeaders getHeaders() {
        return new HttpHeadersImpl(this.httpCarbonMessage.getHeaders());
    }

    public String getHeader(String key) {
        return this.httpCarbonMessage.getHeader(key);
    }

    public Response setHeader(String key, String value) {
        this.httpCarbonMessage.setHeader(key, value);
        return this;
    }

    public void setHeaders(Map<String, String> headerMap) {
        headerMap.forEach(this.httpCarbonMessage::setHeader);
    }

    public Object getProperty(String key) {
        return this.httpCarbonMessage.getProperty(key);
    }

    public Map<String, Object> getProperties() {
        return this.httpCarbonMessage.getProperties();
    }

    public void setProperty(String key, Object value) {
        this.httpCarbonMessage.setProperty(key, value);
    }

    public void removeHeader(String key) {
        this.httpCarbonMessage.removeHeader(key);
    }

    public void removeProperty(String key) {
        this.httpCarbonMessage.removeProperty(key);
    }

    HTTPCarbonMessage getHttpCarbonMessage() {
        return this.httpCarbonMessage;
    }

    public Response setStatus(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public int getStatusCode() {
        if (this.statusCode != -1) {
            return this.statusCode;
        }
        if (this.entity != null) {
            return Response.Status.OK.getStatusCode();
        }
        return Response.Status.NO_CONTENT.getStatusCode();
    }

    public Response setMediaType(String mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public Response setEntity(Object entity) {
        if (!this.httpCarbonMessage.isEmpty()) {
            throw new IllegalStateException("CarbonMessage should not contain a message body");
        }
        if (entity instanceof javax.ws.rs.core.Response) {
            javax.ws.rs.core.Response response;
            this.jaxrsResponse = response = (javax.ws.rs.core.Response)entity;
            this.entity = response.getEntity();
            this.setStatus(response.getStatus());
            if (response.getMediaType() != null) {
                this.setMediaType(response.getMediaType().toString());
            }
        } else {
            this.entity = entity;
        }
        return this;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public void send() {
        Session session;
        this.httpCarbonMessage.setProperty("HTTP_STATUS_CODE", this.getStatusCode());
        ArrayList<String> cookiesHeaderValue = new ArrayList<String>();
        if (this.jaxrsResponse != null) {
            MultivaluedMap<String, String> multivaluedMap = this.jaxrsResponse.getStringHeaders();
            if (multivaluedMap != null) {
                multivaluedMap.forEach((key, strings) -> this.setHeader((String)key, String.join((CharSequence)COMMA_SEPARATOR, strings)));
            }
            Map<String, NewCookie> cookies = this.jaxrsResponse.getCookies();
            CookieHeaderProvider cookieProvider = new CookieHeaderProvider();
            cookies.forEach((name, cookie) -> cookiesHeaderValue.add(cookieProvider.toString((Cookie)cookie)));
        }
        if ((session = this.request.getSessionInternal()) != null && session.isValid() && session.isNew()) {
            cookiesHeaderValue.add("JSESSIONID=" + session.getId());
        }
        for (String cookie2 : cookiesHeaderValue) {
            this.httpCarbonMessage.getHeaders().add("Set-Cookie", (Object)cookie2);
        }
        this.processEntity();
    }

    private void processEntity() {
        if (this.entity != null) {
            EntityWriter entityWriter = EntityWriterRegistry.getEntityWriter(this.entity.getClass());
            entityWriter.writeData(this.httpCarbonMessage, this.entity, this.mediaType, this.chunkSize, this.request.getHttpCarbonMessage());
        } else {
            ByteBuffer byteBuffer = ByteBuffer.allocate(0);
            this.httpCarbonMessage.addHttpContent(new DefaultLastHttpContent(Unpooled.wrappedBuffer(byteBuffer)));
            try {
                this.request.getHttpCarbonMessage().respond(this.httpCarbonMessage);
            }
            catch (ServerConnectorException e) {
                throw new RuntimeException("Error while sending the response.", e);
            }
        }
    }
}

