/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.sender.channel.pool;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLEngine;
import org.apache.commons.pool.PoolableObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.common.HttpRoute;
import org.wso2.transport.http.netty.common.ssl.SSLConfig;
import org.wso2.transport.http.netty.common.ssl.SSLHandlerFactory;
import org.wso2.transport.http.netty.config.SenderConfiguration;
import org.wso2.transport.http.netty.sender.HTTPClientInitializer;
import org.wso2.transport.http.netty.sender.channel.BootstrapConfiguration;
import org.wso2.transport.http.netty.sender.channel.TargetChannel;

public class PoolableTargetChannelFactory
implements PoolableObjectFactory {
    private static final Logger log = LoggerFactory.getLogger(PoolableTargetChannelFactory.class);
    private EventLoopGroup eventLoopGroup;
    private Class eventLoopClass;
    private HttpRoute httpRoute;
    private SenderConfiguration senderConfiguration;

    public PoolableTargetChannelFactory(EventLoopGroup eventLoopGroup, Class eventLoopClass, HttpRoute httpRoute, SenderConfiguration senderConfiguration) {
        this.eventLoopGroup = eventLoopGroup;
        this.eventLoopClass = eventLoopClass;
        this.httpRoute = httpRoute;
        this.senderConfiguration = senderConfiguration;
    }

    @Override
    public Object makeObject() throws Exception {
        Bootstrap clientBootstrap = this.instantiateAndConfigBootStrap(this.eventLoopGroup, this.eventLoopClass, BootstrapConfiguration.getInstance());
        SSLEngine clientSslEngine = this.instantiateAndConfigSSL(this.senderConfiguration.getSslConfig());
        HTTPClientInitializer httpClientInitializer = this.instantiateAndConfigClientInitializer(this.senderConfiguration, clientBootstrap, clientSslEngine);
        clientBootstrap.handler(httpClientInitializer);
        ChannelFuture channelFuture = clientBootstrap.connect(new InetSocketAddress(this.httpRoute.getHost(), this.httpRoute.getPort()));
        TargetChannel targetChannel = new TargetChannel(httpClientInitializer, channelFuture);
        targetChannel.setHttpRoute(this.httpRoute);
        log.debug("Created channel: {}", (Object)this.httpRoute);
        return targetChannel;
    }

    @Override
    public void destroyObject(Object o) throws Exception {
        log.debug("Destroying channel: {}", o);
        if (((TargetChannel)o).getChannel().isOpen()) {
            if (log.isDebugEnabled()) {
                log.debug("And channel id is : " + ((TargetChannel)o).getChannel().id());
            }
            ((TargetChannel)o).getChannel().close();
        }
    }

    @Override
    public boolean validateObject(Object o) {
        if (((TargetChannel)o).getChannel() != null) {
            boolean answer = ((TargetChannel)o).getChannel().isActive();
            log.debug("Validating channel: {} -> {}", o, (Object)answer);
            return answer;
        }
        return true;
    }

    @Override
    public void activateObject(Object o) throws Exception {
    }

    @Override
    public void passivateObject(Object o) throws Exception {
    }

    private Bootstrap instantiateAndConfigBootStrap(EventLoopGroup eventLoopGroup, Class eventLoopClass, BootstrapConfiguration bootstrapConfiguration) {
        Bootstrap clientBootstrap = new Bootstrap();
        clientBootstrap.channel(eventLoopClass);
        clientBootstrap.group(eventLoopGroup);
        clientBootstrap.option(ChannelOption.SO_KEEPALIVE, bootstrapConfiguration.isKeepAlive());
        clientBootstrap.option(ChannelOption.TCP_NODELAY, bootstrapConfiguration.isTcpNoDelay());
        clientBootstrap.option(ChannelOption.SO_REUSEADDR, bootstrapConfiguration.isSocketReuse());
        clientBootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, bootstrapConfiguration.getConnectTimeOut());
        return clientBootstrap;
    }

    private SSLEngine instantiateAndConfigSSL(SSLConfig sslConfig) {
        SSLEngine sslEngine = null;
        if (sslConfig != null) {
            SSLHandlerFactory sslHandlerFactory = new SSLHandlerFactory(sslConfig);
            sslEngine = sslHandlerFactory.build();
            sslEngine.setUseClientMode(true);
            sslHandlerFactory.setSNIServerNames(sslEngine, this.httpRoute.getHost());
        }
        return sslEngine;
    }

    private HTTPClientInitializer instantiateAndConfigClientInitializer(SenderConfiguration senderConfiguration, Bootstrap clientBootstrap, SSLEngine sslEngine) {
        HTTPClientInitializer httpClientInitializer = new HTTPClientInitializer(senderConfiguration, sslEngine);
        if (log.isDebugEnabled()) {
            log.debug("Created new TCP client bootstrap connecting to {}:{} with options: {}", this.httpRoute.getHost(), this.httpRoute.getPort(), clientBootstrap);
        }
        return httpClientInitializer;
    }
}

