/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.config;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.config.ConfigConstants;
import org.yaml.snakeyaml.Yaml;

public class ConfigurationUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationUtils.class);
    private static final Pattern varPattern = Pattern.compile("\\$\\{([^}]*)}");
    private static final char[] specialCharArray = new char[]{'\\', '+', '-', '!', '(', ')', ':', '^', '[', ']', '\"', '{', '}', '~', '*', '?', '|', '&', ';', '/'};

    private ConfigurationUtils() {
    }

    public static Map<String, String> getDeploymentConfigMap(String yamlString) {
        HashMap<String, String> deploymentConfigs = new HashMap<String, String>();
        Yaml yaml = new Yaml();
        Map map = yaml.loadAs(yamlString, Map.class);
        map.entrySet().stream().filter(entry -> entry.getValue() != null).forEach(entry -> deploymentConfigs.put((String)entry.getKey(), yaml.dumpAsMap(entry.getValue())));
        return deploymentConfigs;
    }

    public static Properties loadProjectProperties() {
        Properties properties = new Properties();
        try (InputStream in = ConfigurationUtils.class.getClassLoader().getResourceAsStream("project.defaults.properties");){
            if (in != null) {
                properties.load(in);
            }
        }
        catch (IOException e) {
            logger.error("Error while reading the project default properties, hence apply default values.", e);
        }
        return properties;
    }

    public static String substituteVariables(String value) {
        if (Boolean.getBoolean("config.doc.generation")) {
            return value;
        }
        Matcher matcher = varPattern.matcher(value);
        boolean found = matcher.find();
        if (!found) {
            return value;
        }
        StringBuffer sb = new StringBuffer();
        do {
            String sysPropKey;
            String sysPropValue;
            if ((sysPropValue = ConfigurationUtils.getSystemVariableValue(sysPropKey = matcher.group(1), null)) == null || sysPropValue.length() == 0) {
                String msg = "System property " + sysPropKey + " is not specified";
                logger.error(msg);
                throw new RuntimeException(msg);
            }
            sysPropValue = sysPropValue.replace("\\", "\\\\");
            matcher.appendReplacement(sb, sysPropValue);
        } while (matcher.find());
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String getSystemVariableValue(String variableName, String defaultValue) {
        return ConfigurationUtils.getSystemVariableValue(variableName, defaultValue, ConfigConstants.PlaceHolders.class);
    }

    public static String getSystemVariableValue(String variableName, String defaultValue, Class constantClass) {
        String value = null;
        if (System.getProperty(variableName) != null) {
            value = System.getProperty(variableName);
        } else if (System.getenv(variableName) != null) {
            value = System.getenv(variableName);
        } else {
            try {
                String constant = variableName.replaceAll("\\.", "_").toUpperCase(Locale.getDefault());
                Field field = constantClass.getField(constant);
                value = (String)field.get(constant);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
            if (value == null) {
                value = defaultValue;
            }
        }
        return value;
    }

    public static String escapeSpecialCharacters(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            boolean charExists = false;
            for (char s : specialCharArray) {
                if (c != s) continue;
                charExists = true;
            }
            if (charExists || Character.isWhitespace(c)) {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

