/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.jmx;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.CarbonRuntime;
import org.wso2.carbon.kernel.config.model.CarbonConfiguration;
import org.wso2.carbon.kernel.internal.config.JMXConfiguration;
import org.wso2.carbon.kernel.jmx.connection.SingleAddressRMIServerSocketFactory;
import org.wso2.carbon.kernel.jmx.security.CarbonJMXAuthenticator;

@Component(name="org.wso2.carbon.kernel.jmx.internal.CarbonJMXComponent", immediate=true)
public class CarbonJMXComponent {
    private static final Logger logger = LoggerFactory.getLogger(CarbonJMXComponent.class);
    private static final String JAVA_RMI_SERVER_HOSTNAME = "java.rmi.server.hostname";
    private JMXConnectorServer jmxConnectorServer;
    private Registry rmiRegistry;
    private CarbonRuntime carbonRuntime;

    @Activate
    protected void start(BundleContext bundleContext) {
        try {
            InetAddress[] inetAddresses;
            CarbonConfiguration carbonConfiguration = this.carbonRuntime.getConfiguration();
            JMXConfiguration jmxConfiguration = carbonConfiguration.getJmxConfiguration();
            if (!jmxConfiguration.isEnabled()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Remote JMX is disabled.");
                }
                return;
            }
            String hostname = System.getProperty(JAVA_RMI_SERVER_HOSTNAME);
            if (hostname == null || hostname.isEmpty()) {
                hostname = jmxConfiguration.getHostName();
                System.setProperty(JAVA_RMI_SERVER_HOSTNAME, hostname);
            }
            if ((inetAddresses = InetAddress.getAllByName(hostname)).length == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("No network interface available for '{}' to start JMXConnectorServer", (Object)hostname);
                }
                return;
            }
            SingleAddressRMIServerSocketFactory singleAddressRMIServerSocketFactory = new SingleAddressRMIServerSocketFactory(inetAddresses[0]);
            this.rmiRegistry = LocateRegistry.createRegistry(jmxConfiguration.getRmiRegistryPort(), null, singleAddressRMIServerSocketFactory);
            String jmxURL = "service:jmx:rmi://" + hostname + ":" + jmxConfiguration.getRmiServerPort() + "/jndi/rmi://" + hostname + ":" + jmxConfiguration.getRmiRegistryPort() + "/jmxrmi";
            JMXServiceURL jmxServiceURL = new JMXServiceURL(jmxURL);
            HashMap<String, Object> environment = new HashMap<String, Object>();
            environment.put("jmx.remote.authenticator", new CarbonJMXAuthenticator());
            environment.put("jmx.remote.rmi.server.socket.factory", singleAddressRMIServerSocketFactory);
            this.jmxConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(jmxServiceURL, environment, ManagementFactory.getPlatformMBeanServer());
            this.jmxConnectorServer.start();
            logger.info("JMXServerManager JMX Service URL : " + jmxServiceURL.toString());
        }
        catch (Throwable throwable) {
            logger.error("Failed to start CarbonJMXComponent.", throwable);
        }
    }

    @Deactivate
    protected void stop() throws Exception {
        if (this.jmxConnectorServer != null) {
            this.jmxConnectorServer.stop();
            UnicastRemoteObject.unexportObject(this.rmiRegistry, true);
        }
    }

    @Reference(name="carbon.jmx.carbon.runtime", service=CarbonRuntime.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="unregisterCarbonRuntime")
    protected void registerCarbonRuntime(CarbonRuntime carbonRuntime) {
        this.carbonRuntime = carbonRuntime;
    }

    protected void unregisterCarbonRuntime(CarbonRuntime carbonRuntime) {
        this.carbonRuntime = null;
    }
}

