/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.util;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.wso2.msf4j.Request;
import org.wso2.msf4j.Response;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

public class HttpUtil {
    public static final String EMPTY_BODY = "";
    public static final String CLOSE = "close";
    public static final String KEEP_ALIVE = "keep-alive";

    public static HTTPCarbonMessage createTextResponse(int status, String msg) {
        HTTPCarbonMessage response = new HTTPCarbonMessage(new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf(status)));
        response.setProperty("HTTP_STATUS_CODE", status);
        if (msg != null) {
            response.setHeader("Content-Length", String.valueOf(msg.length()));
            byte[] msgArray = null;
            try {
                msgArray = msg.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Failed to get the byte array from responseValue", e);
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(msgArray.length);
            byteBuffer.put(msgArray);
            byteBuffer.flip();
            response.addHttpContent(new DefaultLastHttpContent(Unpooled.wrappedBuffer(byteBuffer)));
        } else {
            response.setHeader("Content-Length", "0");
        }
        return response;
    }

    public static void setConnectionHeader(Request request, Response response) {
        String connection = request.getHeader("Connection");
        if (connection != null && CLOSE.equalsIgnoreCase(connection)) {
            response.setHeader("Connection", CLOSE);
        } else {
            response.setHeader("Connection", KEEP_ALIVE);
        }
    }
}

