/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl;

import io.netty.channel.ChannelFuture;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.contract.PortBindingEventListener;
import org.wso2.transport.http.netty.contract.ServerConnectorException;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contract.websocket.WebSocketBinaryMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketCloseMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnectorListener;
import org.wso2.transport.http.netty.contract.websocket.WebSocketControlMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketInitMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketTextMessage;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

public class HttpWsServerConnectorFuture
implements ServerConnectorFuture {
    private HttpConnectorListener httpConnectorListener;
    private WebSocketConnectorListener wsConnectorListener;
    private PortBindingEventListener portBindingEventListener;
    private ChannelFuture nettyChannelFuture;
    private String openingServerConnectorId;
    private boolean isOpeningSCHttps;
    private String closingServerConnectorId;
    private boolean isClosingSCHttps;
    private Throwable connectorInitException;

    public HttpWsServerConnectorFuture() {
    }

    public HttpWsServerConnectorFuture(ChannelFuture nettyChannelFuture) {
        this.nettyChannelFuture = nettyChannelFuture;
    }

    @Override
    public void setHttpConnectorListener(HttpConnectorListener httpConnectorListener) {
        this.httpConnectorListener = httpConnectorListener;
    }

    @Override
    public void notifyHttpListener(HTTPCarbonMessage httpMessage) throws ServerConnectorException {
        if (this.httpConnectorListener == null) {
            throw new ServerConnectorException("HTTP connector listener is not set");
        }
        this.httpConnectorListener.onMessage(httpMessage);
    }

    @Override
    public void setWSConnectorListener(WebSocketConnectorListener wsConnectorListener) {
        this.wsConnectorListener = wsConnectorListener;
    }

    @Override
    public void notifyWSListener(WebSocketInitMessage initMessage) throws ServerConnectorException {
        if (this.wsConnectorListener == null) {
            throw new ServerConnectorException("WebSocket connector listener is not set");
        }
        this.wsConnectorListener.onMessage(initMessage);
    }

    @Override
    public void notifyWSListener(WebSocketTextMessage textMessage) throws ServerConnectorException {
        if (this.wsConnectorListener == null) {
            throw new ServerConnectorException("WebSocket connector listener is not set");
        }
        this.wsConnectorListener.onMessage(textMessage);
    }

    @Override
    public void notifyWSListener(WebSocketBinaryMessage binaryMessage) throws ServerConnectorException {
        if (this.wsConnectorListener == null) {
            throw new ServerConnectorException("WebSocket connector listener is not set");
        }
        this.wsConnectorListener.onMessage(binaryMessage);
    }

    @Override
    public void notifyWSListener(WebSocketControlMessage controlMessage) throws ServerConnectorException {
        if (this.wsConnectorListener == null) {
            throw new ServerConnectorException("WebSocket connector listener is not set");
        }
        this.wsConnectorListener.onMessage(controlMessage);
    }

    @Override
    public void notifyWSListener(WebSocketCloseMessage closeMessage) throws ServerConnectorException {
        if (this.wsConnectorListener == null) {
            throw new ServerConnectorException("WebSocket connector listener is not set");
        }
        this.wsConnectorListener.onMessage(closeMessage);
    }

    @Override
    public void notifyWSListener(Throwable throwable) throws ServerConnectorException {
        if (this.wsConnectorListener == null) {
            throw new ServerConnectorException("WebSocket connector listener is not set");
        }
        this.wsConnectorListener.onError(throwable);
    }

    @Override
    public void notifyWSIdleTimeout(WebSocketControlMessage controlMessage) throws ServerConnectorException {
        if (this.wsConnectorListener == null) {
            throw new ServerConnectorException("WebSocket connector listener is not set");
        }
        this.wsConnectorListener.onIdleTimeout(controlMessage);
    }

    @Override
    public void sync() throws InterruptedException {
        this.nettyChannelFuture.sync();
    }

    @Override
    public void notifyErrorListener(Throwable cause) throws ServerConnectorException {
        if (this.httpConnectorListener == null) {
            throw new ServerConnectorException("HTTP connector listener is not set", new Exception(cause));
        }
        this.httpConnectorListener.onError(cause);
    }

    @Override
    public void setPortBindingEventListener(PortBindingEventListener portBindingEventListener) {
        this.portBindingEventListener = portBindingEventListener;
        if (this.openingServerConnectorId != null) {
            this.notifyPortBindingEvent(this.openingServerConnectorId, this.isOpeningSCHttps);
            this.openingServerConnectorId = null;
            this.isOpeningSCHttps = false;
        }
        if (this.closingServerConnectorId != null) {
            this.notifyPortUnbindingEvent(this.closingServerConnectorId, this.isClosingSCHttps);
            this.closingServerConnectorId = null;
            this.isClosingSCHttps = false;
        }
        if (this.connectorInitException != null) {
            this.notifyPortBindingError(this.connectorInitException);
            this.connectorInitException = null;
        }
    }

    @Override
    public void notifyPortBindingEvent(String serverConnectorId, boolean isHttps) {
        if (this.portBindingEventListener == null) {
            this.openingServerConnectorId = serverConnectorId;
            this.isOpeningSCHttps = isHttps;
        } else {
            this.portBindingEventListener.onOpen(serverConnectorId, isHttps);
        }
    }

    @Override
    public void notifyPortUnbindingEvent(String serverConnectorId, boolean isHttps) {
        if (this.portBindingEventListener == null) {
            this.closingServerConnectorId = serverConnectorId;
            this.isClosingSCHttps = isHttps;
        } else {
            this.portBindingEventListener.onClose(serverConnectorId, isHttps);
        }
    }

    @Override
    public void notifyPortBindingError(Throwable throwable) {
        if (this.portBindingEventListener == null) {
            this.connectorInitException = throwable;
        } else {
            this.portBindingEventListener.onError(throwable);
        }
    }
}

