/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.internal.websocket;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.websocket.CloseReason;
import javax.websocket.RemoteEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.internal.websocket.WebSocketAsyncRemoteEndpoint;
import org.wso2.transport.http.netty.internal.websocket.WebSocketBasicRemoteEndpoint;
import org.wso2.transport.http.netty.internal.websocket.WebSocketSessionAdapter;

public class WebSocketSessionImpl
extends WebSocketSessionAdapter {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketSessionImpl.class);
    private final ChannelHandlerContext ctx;
    private final boolean isSecure;
    private final URI requestedUri;
    private final String sessionId;
    private final WebSocketBasicRemoteEndpoint basicRemoteEndpoint;
    private final WebSocketAsyncRemoteEndpoint asyncRemoteEndpoint;
    private String negotiatedSubProtocol = null;
    private boolean isOpen = false;
    private Map<String, Object> userProperties = new HashMap<String, Object>();

    public WebSocketSessionImpl(ChannelHandlerContext ctx, boolean isSecure, String requestedUri, String sessionId) throws URISyntaxException {
        this.ctx = ctx;
        this.isSecure = isSecure;
        this.requestedUri = new URI(requestedUri);
        this.sessionId = sessionId;
        this.basicRemoteEndpoint = new WebSocketBasicRemoteEndpoint(ctx);
        this.asyncRemoteEndpoint = new WebSocketAsyncRemoteEndpoint(ctx);
    }

    @Override
    public RemoteEndpoint.Async getAsyncRemote() {
        return this.asyncRemoteEndpoint;
    }

    @Override
    public RemoteEndpoint.Basic getBasicRemote() {
        return this.basicRemoteEndpoint;
    }

    @Override
    public String getId() {
        return this.sessionId;
    }

    @Override
    public void close() throws IOException {
        this.ctx.channel().close();
        this.isOpen = false;
    }

    @Override
    public void close(CloseReason closeReason) {
        this.ctx.channel().writeAndFlush(new CloseWebSocketFrame(closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase()));
        this.ctx.channel().close();
        this.isOpen = false;
    }

    @Override
    public URI getRequestURI() {
        return this.requestedUri;
    }

    @Override
    public String getNegotiatedSubprotocol() {
        return this.negotiatedSubProtocol;
    }

    public void setNegotiatedSubProtocol(String negotiatedSubProtocol) {
        this.negotiatedSubProtocol = negotiatedSubProtocol;
    }

    @Override
    public boolean isSecure() {
        return this.isSecure;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public Map<String, Object> getUserProperties() {
        return this.userProperties;
    }

    public void setIsOpen(boolean isOpen) {
        this.isOpen = isOpen;
    }

    public void addUserProperty(String key, Object value) {
        this.userProperties.put(key, value);
    }
}

