/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.listener;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http2.Http2CodecUtil;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.listener.Http2SourceHandlerBuilder;

public class Http2WithPriorKnowledgeHandler
extends ChannelInboundHandlerAdapter {
    private String interfaceId;
    private String serverName;
    private ServerConnectorFuture serverConnectorFuture;

    public Http2WithPriorKnowledgeHandler(String interfaceId, String serverName, ServerConnectorFuture serverConnectorFuture) {
        this.interfaceId = interfaceId;
        this.serverName = serverName;
        this.serverConnectorFuture = serverConnectorFuture;
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            ByteBuf inputData = (ByteBuf)msg;
            ByteBuf clientPrefaceString = Http2CodecUtil.connectionPrefaceBuf();
            int bytesRead = Math.min(inputData.readableBytes(), clientPrefaceString.readableBytes());
            ChannelPipeline pipeline = ctx.pipeline();
            if (ByteBufUtil.equals(inputData, inputData.readerIndex(), clientPrefaceString, clientPrefaceString.readerIndex(), bytesRead)) {
                pipeline.remove("ServerCodec");
                pipeline.addBefore("Http2UpgradeHandler", "Http2SourceHandler", new Http2SourceHandlerBuilder(this.interfaceId, this.serverConnectorFuture, this.serverName).build());
                pipeline.remove("Http2UpgradeHandler");
            }
            pipeline.remove(this);
            ctx.fireChannelRead(msg);
        }
    }
}

