/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.sender;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.listener.HTTPTraceLoggingHandler;
import org.wso2.transport.http.netty.sender.HttpClientChannelInitializer;
import org.wso2.transport.http.netty.sender.RedirectHandler;
import org.wso2.transport.http.netty.sender.channel.pool.ConnectionManager;

public class RedirectChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger log = LoggerFactory.getLogger(HttpClientChannelInitializer.class);
    private SSLEngine sslEngine;
    private boolean httpTraceLogEnabled;
    private int maxRedirectCount;
    private ChannelHandlerContext originalChannelContext;
    private boolean isIdleHandlerOfTargetChannelRemoved;
    private ConnectionManager connectionManager;

    public RedirectChannelInitializer(SSLEngine sslEngine, boolean httpTraceLogEnabled, int maxRedirectCount, ChannelHandlerContext originalChannelContext, boolean isIdleHandlerOfTargetChannelRemoved, ConnectionManager connectionManager) {
        this.sslEngine = sslEngine;
        this.httpTraceLogEnabled = httpTraceLogEnabled;
        this.maxRedirectCount = maxRedirectCount;
        this.originalChannelContext = originalChannelContext;
        this.isIdleHandlerOfTargetChannelRemoved = isIdleHandlerOfTargetChannelRemoved;
        this.connectionManager = connectionManager;
    }

    @Override
    protected void initChannel(SocketChannel ch) throws Exception {
        if (this.sslEngine != null) {
            if (log.isDebugEnabled()) {
                log.debug("adding ssl handler");
            }
            ch.pipeline().addLast("ssl", (ChannelHandler)new SslHandler(this.sslEngine));
        }
        ch.pipeline().addLast("compressor", (ChannelHandler)new HttpContentCompressor());
        ch.pipeline().addLast("decoder", (ChannelHandler)new HttpResponseDecoder());
        ch.pipeline().addLast("encoder", (ChannelHandler)new HttpRequestEncoder());
        if (this.httpTraceLogEnabled) {
            ch.pipeline().addLast("http-trace-logger", (ChannelHandler)new HTTPTraceLoggingHandler("tracelog.http.upstream"));
        }
        RedirectHandler redirectHandler = new RedirectHandler(this.sslEngine, this.httpTraceLogEnabled, this.maxRedirectCount, this.originalChannelContext, this.isIdleHandlerOfTargetChannelRemoved, this.connectionManager);
        ch.pipeline().addLast("redirectHandler", (ChannelHandler)redirectHandler);
    }
}

