/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.sender.http2;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contractimpl.DefaultHttpResponseFuture;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.transport.http.netty.message.Http2PushPromise;
import org.wso2.transport.http.netty.message.HttpCarbonResponse;
import org.wso2.transport.http.netty.sender.http2.Http2ClientChannel;

public class OutboundMsgHolder {
    private HTTPCarbonMessage requestCarbonMessage;
    private BlockingQueue<Http2PushPromise> promises;
    private ConcurrentHashMap<Integer, HttpCarbonResponse> pushResponsesMap;
    private HttpCarbonResponse response;
    private HttpResponseFuture responseFuture;
    private Http2ClientChannel http2ClientChannel;
    private boolean allPromisesReceived = false;
    private long lastReadWriteTime;
    private boolean requestWritten;

    public OutboundMsgHolder(HTTPCarbonMessage httpCarbonMessage, Http2ClientChannel http2ClientChannel) {
        this.requestCarbonMessage = httpCarbonMessage;
        this.http2ClientChannel = http2ClientChannel;
        this.promises = new LinkedBlockingQueue<Http2PushPromise>();
        this.pushResponsesMap = new ConcurrentHashMap();
        this.responseFuture = new DefaultHttpResponseFuture(this);
    }

    public HTTPCarbonMessage getRequest() {
        return this.requestCarbonMessage;
    }

    public HttpResponseFuture getResponseFuture() {
        return this.responseFuture;
    }

    public Http2ClientChannel getHttp2ClientChannel() {
        return this.http2ClientChannel;
    }

    void addPromise(Http2PushPromise pushPromise) {
        this.promises.add(pushPromise);
        this.responseFuture.notifyPromiseAvailability();
        this.responseFuture.notifyPushPromise();
    }

    void addPushResponse(int streamId, HttpCarbonResponse pushResponse) {
        this.pushResponsesMap.put(streamId, pushResponse);
        this.responseFuture.notifyPushResponse(streamId, pushResponse);
    }

    public boolean isAllPromisesReceived() {
        return this.allPromisesReceived;
    }

    public void markNoPromisesReceived() {
        this.allPromisesReceived = true;
        this.responseFuture.notifyPromiseAvailability();
    }

    public HttpCarbonResponse getPushResponse(int steamId) {
        return this.pushResponsesMap.get(steamId);
    }

    public HttpCarbonResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpCarbonResponse response) {
        this.response = response;
        this.allPromisesReceived = true;
        this.responseFuture.notifyPromiseAvailability();
        this.responseFuture.notifyHttpListener(response);
    }

    public boolean hasPromise() {
        return !this.promises.isEmpty();
    }

    public Http2PushPromise getNextPromise() {
        return (Http2PushPromise)this.promises.poll();
    }

    long getLastReadWriteTime() {
        return this.lastReadWriteTime;
    }

    void setLastReadWriteTime(long lastReadWriteTime) {
        this.lastReadWriteTime = lastReadWriteTime;
    }

    public boolean isRequestWritten() {
        return this.requestWritten;
    }

    public void setRequestWritten(boolean requestWritten) {
        this.requestWritten = requestWritten;
    }
}

