/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.sender.websocket;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.IdleStateHandler;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.websocket.HandshakeFuture;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnectorListener;
import org.wso2.transport.http.netty.contractimpl.websocket.HandshakeFutureImpl;
import org.wso2.transport.http.netty.internal.websocket.WebSocketSessionImpl;
import org.wso2.transport.http.netty.sender.websocket.WebSocketTargetHandler;

public class WebSocketClient {
    private static final Logger log = LoggerFactory.getLogger(WebSocketClient.class);
    private WebSocketTargetHandler webSocketTargetHandler;
    private final String url;
    private final String subProtocols;
    private final int idleTimeout;
    private final Map<String, String> headers;
    private final WebSocketConnectorListener connectorListener;
    private final EventLoopGroup wsClientEventLoopGroup;

    public WebSocketClient(String url, String subProtocols, int idleTimeout, EventLoopGroup wsClientEventLoopGroup, Map<String, String> headers, WebSocketConnectorListener connectorListener) {
        this.url = url;
        this.subProtocols = subProtocols;
        this.idleTimeout = idleTimeout;
        this.headers = headers;
        this.connectorListener = connectorListener;
        this.wsClientEventLoopGroup = wsClientEventLoopGroup;
    }

    public HandshakeFuture handshake() {
        HandshakeFutureImpl handshakeFuture = new HandshakeFutureImpl();
        try {
            URI uri = new URI(this.url);
            String scheme = uri.getScheme() == null ? "ws" : uri.getScheme();
            final String host = uri.getHost() == null ? "127.0.0.1" : uri.getHost();
            final int port = this.getPort(uri);
            if (!"ws".equalsIgnoreCase(scheme) && !"wss".equalsIgnoreCase(scheme)) {
                log.error("Only WS(S) is supported.");
                throw new SSLException("");
            }
            boolean ssl = "wss".equalsIgnoreCase(scheme);
            final SslContext sslCtx = this.getSslContext(ssl);
            DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
            if (this.headers != null) {
                this.headers.forEach(httpHeaders::add);
            }
            WebSocketClientHandshaker websocketHandshaker = WebSocketClientHandshakerFactory.newHandshaker(uri, WebSocketVersion.V13, this.subProtocols, true, httpHeaders);
            this.webSocketTargetHandler = new WebSocketTargetHandler(websocketHandshaker, ssl, this.url, this.connectorListener);
            Bootstrap clientBootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)clientBootstrap.group(this.wsClientEventLoopGroup)).channel(NioSocketChannel.class)).handler(new ChannelInitializer<SocketChannel>(){

                @Override
                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline pipeline = ch.pipeline();
                    if (sslCtx != null) {
                        pipeline.addLast(sslCtx.newHandler(ch.alloc(), host, port));
                    }
                    pipeline.addLast(new HttpClientCodec());
                    pipeline.addLast(new HttpObjectAggregator(8192));
                    pipeline.addLast(WebSocketClientCompressionHandler.INSTANCE);
                    if (WebSocketClient.this.idleTimeout > 0) {
                        pipeline.addLast(new IdleStateHandler(WebSocketClient.this.idleTimeout, WebSocketClient.this.idleTimeout, WebSocketClient.this.idleTimeout, TimeUnit.MILLISECONDS));
                    }
                    pipeline.addLast(WebSocketClient.this.webSocketTargetHandler);
                }
            });
            clientBootstrap.connect(uri.getHost(), port).sync();
            ChannelFuture future = this.webSocketTargetHandler.handshakeFuture().addListener(clientHandshakeFuture -> {
                Throwable cause = clientHandshakeFuture.cause();
                if (clientHandshakeFuture.isSuccess() && cause == null) {
                    WebSocketSessionImpl session = (WebSocketSessionImpl)this.webSocketTargetHandler.getChannelSession();
                    String actualSubProtocol = websocketHandshaker.actualSubprotocol();
                    this.webSocketTargetHandler.setActualSubProtocol(actualSubProtocol);
                    session.setNegotiatedSubProtocol(actualSubProtocol);
                    session.setIsOpen(true);
                    handshakeFuture.notifySuccess(session);
                } else {
                    handshakeFuture.notifyError(cause);
                }
            }).sync();
            handshakeFuture.setChannelFuture(future);
        }
        catch (Throwable t) {
            handshakeFuture.notifyError(t);
        }
        return handshakeFuture;
    }

    private int getPort(URI uri) {
        String scheme = uri.getScheme();
        if (uri.getPort() == -1) {
            switch (scheme) {
                case "ws": {
                    return 80;
                }
                case "wss": {
                    return 443;
                }
            }
            return -1;
        }
        return uri.getPort();
    }

    private SslContext getSslContext(boolean ssl) throws SSLException {
        if (ssl) {
            return SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
        }
        return null;
    }
}

