/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.common.certificatevalidation.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.common.certificatevalidation.cache.ManageableCache;
import org.wso2.transport.http.netty.common.certificatevalidation.cache.ManageableCacheValue;

public class CacheManager {
    private final boolean doNotInterruptIfRunning = false;
    private ScheduledExecutorService scheduler;
    private ScheduledFuture scheduledFuture = null;
    private ManageableCache cache;
    private int cacheMaxSize;
    private int delay;
    private CacheManagingTask cacheManagingTask;
    private static final Logger log = LoggerFactory.getLogger(CacheManager.class);

    public CacheManager(ManageableCache cache, int cacheMaxSize, int delay) {
        int numThreads = 1;
        this.scheduler = Executors.newScheduledThreadPool(numThreads);
        this.cache = cache;
        this.cacheMaxSize = cacheMaxSize;
        this.cacheManagingTask = new CacheManagingTask();
        this.delay = delay;
        this.start();
    }

    private boolean start() {
        if (this.scheduledFuture == null || this.scheduledFuture.isCancelled()) {
            this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(this.cacheManagingTask, this.delay, this.delay, TimeUnit.MINUTES);
            if (log.isDebugEnabled()) {
                log.debug(this.cache.getClass().getSimpleName() + " Cache Manager Started.");
            }
            return true;
        }
        return false;
    }

    public boolean wakeUpNow() {
        if (this.scheduledFuture != null) {
            if (!this.scheduledFuture.isCancelled()) {
                this.scheduledFuture.cancel(false);
            }
            this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(this.cacheManagingTask, 0L, this.delay, TimeUnit.MINUTES);
            if (log.isDebugEnabled()) {
                log.debug(this.cache.getClass().getSimpleName() + " Cache Manager woke up.");
            }
            return true;
        }
        return false;
    }

    public boolean changeDelay(int delay) throws IllegalArgumentException {
        int min = 1;
        int max = 1440;
        if (delay < min || delay > max) {
            throw new IllegalArgumentException("Delay time should should be between " + min + " and " + max + " minutes");
        }
        this.delay = delay;
        return this.wakeUpNow();
    }

    public int getDelay() {
        return this.delay;
    }

    public boolean stop() {
        if (this.scheduledFuture != null && !this.scheduledFuture.isCancelled()) {
            this.scheduledFuture.cancel(false);
            if (log.isDebugEnabled()) {
                log.debug(this.cache.getClass().getSimpleName() + " Cache Manager stopped.");
            }
            return true;
        }
        return false;
    }

    public boolean isRunning() {
        return !this.scheduledFuture.isCancelled();
    }

    private class CacheManagingTask
    implements Runnable {
        private CacheManagingTask() {
        }

        @Override
        public void run() {
            int cacheSize;
            long start = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug(CacheManager.this.cache.getClass().getSimpleName() + " Cache Manager Task Started.");
            }
            int numberToRemove = (cacheSize = CacheManager.this.cache.getCacheSize()) > CacheManager.this.cacheMaxSize ? cacheSize - CacheManager.this.cacheMaxSize : 0;
            ArrayList<ManageableCacheValue> entriesToRemove = new ArrayList<ManageableCacheValue>();
            LRUEntryCollector lruEntryCollector = new LRUEntryCollector(entriesToRemove, numberToRemove);
            CacheManager.this.cache.resetIterator();
            while (cacheSize-- > 0) {
                ManageableCacheValue nextCacheValue = CacheManager.this.cache.getNextCacheValue();
                if (nextCacheValue == null) {
                    if (!log.isDebugEnabled()) break;
                    log.debug("Cache manager iteration through Cache values done");
                    break;
                }
                if (!nextCacheValue.isValid()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Updating Invalid Cache Value by Manager");
                    }
                    nextCacheValue.updateCacheWithNewValue();
                }
                if (numberToRemove <= 0) continue;
                lruEntryCollector.collectEntriesToRemove(nextCacheValue);
            }
            for (ManageableCacheValue oldCacheValue : entriesToRemove) {
                if (log.isDebugEnabled()) {
                    log.debug("Removing LRU value from cache");
                }
                oldCacheValue.removeThisCacheValue();
            }
            if (log.isDebugEnabled()) {
                log.debug(CacheManager.this.cache.getClass().getSimpleName() + " Cache Manager Task Done. Took " + (System.currentTimeMillis() - start) + " ms.");
            }
        }

        private class LRUEntryCollector {
            private List<ManageableCacheValue> entriesToRemove;
            private int listMaxSize;

            LRUEntryCollector(List<ManageableCacheValue> entriesToRemove, int numberToRemove) {
                this.entriesToRemove = entriesToRemove;
                this.listMaxSize = numberToRemove;
            }

            private void collectEntriesToRemove(ManageableCacheValue value) {
                int j;
                this.entriesToRemove.add(value);
                for (j = this.entriesToRemove.size() - 1; j > 0 && value.getTimeStamp() < this.entriesToRemove.get(j - 1).getTimeStamp(); --j) {
                    this.entriesToRemove.remove(j);
                    this.entriesToRemove.add(j, this.entriesToRemove.get(j - 1));
                }
                this.entriesToRemove.remove(j);
                this.entriesToRemove.add(j, value);
                if (this.entriesToRemove.size() > this.listMaxSize) {
                    this.entriesToRemove.remove(this.entriesToRemove.size() - 1);
                }
            }
        }
    }
}

